/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateMaintenanceWindowTargetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String windowId;
    private String windowTargetId;
    private SdkInternalList<Target> targets;
    private String ownerInformation;
    private String name;
    private String description;
    private Boolean replace;

    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public UpdateMaintenanceWindowTargetRequest withWindowId(String windowId) {
        this.setWindowId(windowId);
        return this;
    }

    public void setWindowTargetId(String windowTargetId) {
        this.windowTargetId = windowTargetId;
    }

    public String getWindowTargetId() {
        return this.windowTargetId;
    }

    public UpdateMaintenanceWindowTargetRequest withWindowTargetId(String windowTargetId) {
        this.setWindowTargetId(windowTargetId);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public UpdateMaintenanceWindowTargetRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public UpdateMaintenanceWindowTargetRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setOwnerInformation(String ownerInformation) {
        this.ownerInformation = ownerInformation;
    }

    public String getOwnerInformation() {
        return this.ownerInformation;
    }

    public UpdateMaintenanceWindowTargetRequest withOwnerInformation(String ownerInformation) {
        this.setOwnerInformation(ownerInformation);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateMaintenanceWindowTargetRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateMaintenanceWindowTargetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setReplace(Boolean replace) {
        this.replace = replace;
    }

    public Boolean getReplace() {
        return this.replace;
    }

    public UpdateMaintenanceWindowTargetRequest withReplace(Boolean replace) {
        this.setReplace(replace);
        return this;
    }

    public Boolean isReplace() {
        return this.replace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWindowId() != null) {
            sb.append("WindowId: ").append(this.getWindowId()).append(",");
        }
        if (this.getWindowTargetId() != null) {
            sb.append("WindowTargetId: ").append(this.getWindowTargetId()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getOwnerInformation() != null) {
            sb.append("OwnerInformation: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getReplace() != null) {
            sb.append("Replace: ").append(this.getReplace());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowTargetRequest)) {
            return false;
        }
        UpdateMaintenanceWindowTargetRequest other = (UpdateMaintenanceWindowTargetRequest)obj;
        if (other.getWindowId() == null ^ this.getWindowId() == null) {
            return false;
        }
        if (other.getWindowId() != null && !other.getWindowId().equals(this.getWindowId())) {
            return false;
        }
        if (other.getWindowTargetId() == null ^ this.getWindowTargetId() == null) {
            return false;
        }
        if (other.getWindowTargetId() != null && !other.getWindowTargetId().equals(this.getWindowTargetId())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getOwnerInformation() == null ^ this.getOwnerInformation() == null) {
            return false;
        }
        if (other.getOwnerInformation() != null && !other.getOwnerInformation().equals(this.getOwnerInformation())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getReplace() == null ^ this.getReplace() == null) {
            return false;
        }
        return other.getReplace() == null || other.getReplace().equals(this.getReplace());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWindowId() == null ? 0 : this.getWindowId().hashCode());
        hashCode = 31 * hashCode + (this.getWindowTargetId() == null ? 0 : this.getWindowTargetId().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerInformation() == null ? 0 : this.getOwnerInformation().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getReplace() == null ? 0 : this.getReplace().hashCode());
        return hashCode;
    }

    public UpdateMaintenanceWindowTargetRequest clone() {
        return (UpdateMaintenanceWindowTargetRequest)super.clone();
    }
}

