/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.OpsFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.OpsAggregatorMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpsAggregator
implements Serializable,
Cloneable,
StructuredPojo {
    private String aggregatorType;
    private String typeName;
    private String attributeName;
    private Map<String, String> values;
    private SdkInternalList<OpsFilter> filters;
    private SdkInternalList<OpsAggregator> aggregators;

    public void setAggregatorType(String aggregatorType) {
        this.aggregatorType = aggregatorType;
    }

    public String getAggregatorType() {
        return this.aggregatorType;
    }

    public OpsAggregator withAggregatorType(String aggregatorType) {
        this.setAggregatorType(aggregatorType);
        return this;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public OpsAggregator withTypeName(String typeName) {
        this.setTypeName(typeName);
        return this;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public OpsAggregator withAttributeName(String attributeName) {
        this.setAttributeName(attributeName);
        return this;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setValues(Map<String, String> values) {
        this.values = values;
    }

    public OpsAggregator withValues(Map<String, String> values) {
        this.setValues(values);
        return this;
    }

    public OpsAggregator addValuesEntry(String key, String value) {
        if (null == this.values) {
            this.values = new HashMap<String, String>();
        }
        if (this.values.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.values.put(key, value);
        return this;
    }

    public OpsAggregator clearValuesEntries() {
        this.values = null;
        return this;
    }

    public List<OpsFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<OpsFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public OpsAggregator withFilters(OpsFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<OpsFilter>)new SdkInternalList(filters.length));
        }
        for (OpsFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public OpsAggregator withFilters(Collection<OpsFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<OpsAggregator> getAggregators() {
        if (this.aggregators == null) {
            this.aggregators = new SdkInternalList();
        }
        return this.aggregators;
    }

    public void setAggregators(Collection<OpsAggregator> aggregators) {
        if (aggregators == null) {
            this.aggregators = null;
            return;
        }
        this.aggregators = new SdkInternalList(aggregators);
    }

    public OpsAggregator withAggregators(OpsAggregator ... aggregators) {
        if (this.aggregators == null) {
            this.setAggregators((Collection<OpsAggregator>)new SdkInternalList(aggregators.length));
        }
        for (OpsAggregator ele : aggregators) {
            this.aggregators.add((Object)ele);
        }
        return this;
    }

    public OpsAggregator withAggregators(Collection<OpsAggregator> aggregators) {
        this.setAggregators(aggregators);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAggregatorType() != null) {
            sb.append("AggregatorType: ").append(this.getAggregatorType()).append(",");
        }
        if (this.getTypeName() != null) {
            sb.append("TypeName: ").append(this.getTypeName()).append(",");
        }
        if (this.getAttributeName() != null) {
            sb.append("AttributeName: ").append(this.getAttributeName()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getAggregators() != null) {
            sb.append("Aggregators: ").append(this.getAggregators());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsAggregator)) {
            return false;
        }
        OpsAggregator other = (OpsAggregator)obj;
        if (other.getAggregatorType() == null ^ this.getAggregatorType() == null) {
            return false;
        }
        if (other.getAggregatorType() != null && !other.getAggregatorType().equals(this.getAggregatorType())) {
            return false;
        }
        if (other.getTypeName() == null ^ this.getTypeName() == null) {
            return false;
        }
        if (other.getTypeName() != null && !other.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        if (other.getAttributeName() == null ^ this.getAttributeName() == null) {
            return false;
        }
        if (other.getAttributeName() != null && !other.getAttributeName().equals(this.getAttributeName())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getAggregators() == null ^ this.getAggregators() == null) {
            return false;
        }
        return other.getAggregators() == null || other.getAggregators().equals(this.getAggregators());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAggregatorType() == null ? 0 : this.getAggregatorType().hashCode());
        hashCode = 31 * hashCode + (this.getTypeName() == null ? 0 : this.getTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeName() == null ? 0 : this.getAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAggregators() == null ? 0 : this.getAggregators().hashCode());
        return hashCode;
    }

    public OpsAggregator clone() {
        try {
            return (OpsAggregator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpsAggregatorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

