/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UntagQueueRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private SdkInternalList<String> tagKeys;

    public UntagQueueRequest() {
    }

    public UntagQueueRequest(String queueUrl, List<String> tagKeys) {
        this.setQueueUrl(queueUrl);
        this.setTagKeys(tagKeys);
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public UntagQueueRequest withQueueUrl(String queueUrl) {
        this.setQueueUrl(queueUrl);
        return this;
    }

    public List<String> getTagKeys() {
        if (this.tagKeys == null) {
            this.tagKeys = new SdkInternalList();
        }
        return this.tagKeys;
    }

    public void setTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
            return;
        }
        this.tagKeys = new SdkInternalList(tagKeys);
    }

    public UntagQueueRequest withTagKeys(String ... tagKeys) {
        if (this.tagKeys == null) {
            this.setTagKeys((Collection<String>)new SdkInternalList(tagKeys.length));
        }
        for (String ele : tagKeys) {
            this.tagKeys.add((Object)ele);
        }
        return this;
    }

    public UntagQueueRequest withTagKeys(Collection<String> tagKeys) {
        this.setTagKeys(tagKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: ").append(this.getQueueUrl()).append(",");
        }
        if (this.getTagKeys() != null) {
            sb.append("TagKeys: ").append(this.getTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagQueueRequest)) {
            return false;
        }
        UntagQueueRequest other = (UntagQueueRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getTagKeys() == null ^ this.getTagKeys() == null) {
            return false;
        }
        return other.getTagKeys() == null || other.getTagKeys().equals(this.getTagKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getTagKeys() == null ? 0 : this.getTagKeys().hashCode());
        return hashCode;
    }

    public UntagQueueRequest clone() {
        return (UntagQueueRequest)super.clone();
    }
}

