/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.CreateJobRequest;
import com.amazonaws.services.snowball.model.transform.JobResourceJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.NotificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createJobRequest, "AmazonSnowball");
        request.addHeader("X-Amz-Target", "AWSIESnowballJobManagementService.CreateJob");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createJobRequest.getJobType() != null) {
                jsonGenerator.writeFieldName("JobType").writeValue(createJobRequest.getJobType());
            }
            if (createJobRequest.getResources() != null) {
                jsonGenerator.writeFieldName("Resources");
                JobResourceJsonMarshaller.getInstance().marshall(createJobRequest.getResources(), jsonGenerator);
            }
            if (createJobRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createJobRequest.getDescription());
            }
            if (createJobRequest.getAddressId() != null) {
                jsonGenerator.writeFieldName("AddressId").writeValue(createJobRequest.getAddressId());
            }
            if (createJobRequest.getKmsKeyARN() != null) {
                jsonGenerator.writeFieldName("KmsKeyARN").writeValue(createJobRequest.getKmsKeyARN());
            }
            if (createJobRequest.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(createJobRequest.getRoleARN());
            }
            if (createJobRequest.getSnowballCapacityPreference() != null) {
                jsonGenerator.writeFieldName("SnowballCapacityPreference").writeValue(createJobRequest.getSnowballCapacityPreference());
            }
            if (createJobRequest.getShippingOption() != null) {
                jsonGenerator.writeFieldName("ShippingOption").writeValue(createJobRequest.getShippingOption());
            }
            if (createJobRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(createJobRequest.getNotification(), jsonGenerator);
            }
            if (createJobRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(createJobRequest.getClusterId());
            }
            if (createJobRequest.getSnowballType() != null) {
                jsonGenerator.writeFieldName("SnowballType").writeValue(createJobRequest.getSnowballType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

