/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model;

import com.amazonaws.services.snowball.model.JobState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Notification
implements Serializable,
Cloneable {
    private String snsTopicARN;
    private List<String> jobStatesToNotify;
    private Boolean notifyAll;

    public void setSnsTopicARN(String snsTopicARN) {
        this.snsTopicARN = snsTopicARN;
    }

    public String getSnsTopicARN() {
        return this.snsTopicARN;
    }

    public Notification withSnsTopicARN(String snsTopicARN) {
        this.setSnsTopicARN(snsTopicARN);
        return this;
    }

    public List<String> getJobStatesToNotify() {
        return this.jobStatesToNotify;
    }

    public void setJobStatesToNotify(Collection<String> jobStatesToNotify) {
        if (jobStatesToNotify == null) {
            this.jobStatesToNotify = null;
            return;
        }
        this.jobStatesToNotify = new ArrayList<String>(jobStatesToNotify);
    }

    public Notification withJobStatesToNotify(String ... jobStatesToNotify) {
        if (this.jobStatesToNotify == null) {
            this.setJobStatesToNotify(new ArrayList<String>(jobStatesToNotify.length));
        }
        for (String ele : jobStatesToNotify) {
            this.jobStatesToNotify.add(ele);
        }
        return this;
    }

    public Notification withJobStatesToNotify(Collection<String> jobStatesToNotify) {
        this.setJobStatesToNotify(jobStatesToNotify);
        return this;
    }

    public Notification withJobStatesToNotify(JobState ... jobStatesToNotify) {
        ArrayList<String> jobStatesToNotifyCopy = new ArrayList<String>(jobStatesToNotify.length);
        for (JobState value : jobStatesToNotify) {
            jobStatesToNotifyCopy.add(value.toString());
        }
        if (this.getJobStatesToNotify() == null) {
            this.setJobStatesToNotify(jobStatesToNotifyCopy);
        } else {
            this.getJobStatesToNotify().addAll(jobStatesToNotifyCopy);
        }
        return this;
    }

    public void setNotifyAll(Boolean notifyAll) {
        this.notifyAll = notifyAll;
    }

    public Boolean getNotifyAll() {
        return this.notifyAll;
    }

    public Notification withNotifyAll(Boolean notifyAll) {
        this.setNotifyAll(notifyAll);
        return this;
    }

    public Boolean isNotifyAll() {
        return this.notifyAll;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnsTopicARN() != null) {
            sb.append("SnsTopicARN: " + this.getSnsTopicARN() + ",");
        }
        if (this.getJobStatesToNotify() != null) {
            sb.append("JobStatesToNotify: " + this.getJobStatesToNotify() + ",");
        }
        if (this.getNotifyAll() != null) {
            sb.append("NotifyAll: " + this.getNotifyAll());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        if (other.getSnsTopicARN() == null ^ this.getSnsTopicARN() == null) {
            return false;
        }
        if (other.getSnsTopicARN() != null && !other.getSnsTopicARN().equals(this.getSnsTopicARN())) {
            return false;
        }
        if (other.getJobStatesToNotify() == null ^ this.getJobStatesToNotify() == null) {
            return false;
        }
        if (other.getJobStatesToNotify() != null && !other.getJobStatesToNotify().equals(this.getJobStatesToNotify())) {
            return false;
        }
        if (other.getNotifyAll() == null ^ this.getNotifyAll() == null) {
            return false;
        }
        return other.getNotifyAll() == null || other.getNotifyAll().equals(this.getNotifyAll());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnsTopicARN() == null ? 0 : this.getSnsTopicARN().hashCode());
        hashCode = 31 * hashCode + (this.getJobStatesToNotify() == null ? 0 : this.getJobStatesToNotify().hashCode());
        hashCode = 31 * hashCode + (this.getNotifyAll() == null ? 0 : this.getNotifyAll().hashCode());
        return hashCode;
    }

    public Notification clone() {
        try {
            return (Notification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

