/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.Address;

public class AddressJsonMarshaller {
    private static AddressJsonMarshaller instance;

    public void marshall(Address address, StructuredJsonGenerator jsonGenerator) {
        if (address == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (address.getAddressId() != null) {
                jsonGenerator.writeFieldName("AddressId").writeValue(address.getAddressId());
            }
            if (address.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(address.getName());
            }
            if (address.getCompany() != null) {
                jsonGenerator.writeFieldName("Company").writeValue(address.getCompany());
            }
            if (address.getStreet1() != null) {
                jsonGenerator.writeFieldName("Street1").writeValue(address.getStreet1());
            }
            if (address.getStreet2() != null) {
                jsonGenerator.writeFieldName("Street2").writeValue(address.getStreet2());
            }
            if (address.getStreet3() != null) {
                jsonGenerator.writeFieldName("Street3").writeValue(address.getStreet3());
            }
            if (address.getCity() != null) {
                jsonGenerator.writeFieldName("City").writeValue(address.getCity());
            }
            if (address.getStateOrProvince() != null) {
                jsonGenerator.writeFieldName("StateOrProvince").writeValue(address.getStateOrProvince());
            }
            if (address.getPrefectureOrDistrict() != null) {
                jsonGenerator.writeFieldName("PrefectureOrDistrict").writeValue(address.getPrefectureOrDistrict());
            }
            if (address.getLandmark() != null) {
                jsonGenerator.writeFieldName("Landmark").writeValue(address.getLandmark());
            }
            if (address.getCountry() != null) {
                jsonGenerator.writeFieldName("Country").writeValue(address.getCountry());
            }
            if (address.getPostalCode() != null) {
                jsonGenerator.writeFieldName("PostalCode").writeValue(address.getPostalCode());
            }
            if (address.getPhoneNumber() != null) {
                jsonGenerator.writeFieldName("PhoneNumber").writeValue(address.getPhoneNumber());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AddressJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AddressJsonMarshaller();
        }
        return instance;
    }
}

