/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.snowball.model.S3Resource;

@SdkInternalApi
public class S3ResourceMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketArn").build();
    private static final MarshallingInfo<StructuredPojo> KEYRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyRange").build();
    private static final S3ResourceMarshaller instance = new S3ResourceMarshaller();

    public static S3ResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Resource s3Resource, ProtocolMarshaller protocolMarshaller) {
        if (s3Resource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Resource.getBucketArn(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3Resource.getKeyRange(), KEYRANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

