/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simspaceweaver.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simspaceweaver.model.LogDestination;
import com.amazonaws.services.simspaceweaver.model.transform.LoggingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoggingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<LogDestination> destinations;

    public List<LogDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<LogDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<LogDestination>(destinations);
    }

    public LoggingConfiguration withDestinations(LogDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<LogDestination>(destinations.length));
        }
        for (LogDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public LoggingConfiguration withDestinations(Collection<LogDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        return other.getDestinations() == null || other.getDestinations().equals(this.getDestinations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        return hashCode;
    }

    public LoggingConfiguration clone() {
        try {
            return (LoggingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

