/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simspaceweaver.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.simspaceweaver.model.SimulationAppMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAppsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SimulationAppMetadata> apps;
    private String nextToken;

    public List<SimulationAppMetadata> getApps() {
        return this.apps;
    }

    public void setApps(Collection<SimulationAppMetadata> apps) {
        if (apps == null) {
            this.apps = null;
            return;
        }
        this.apps = new ArrayList<SimulationAppMetadata>(apps);
    }

    public ListAppsResult withApps(SimulationAppMetadata ... apps) {
        if (this.apps == null) {
            this.setApps(new ArrayList<SimulationAppMetadata>(apps.length));
        }
        for (SimulationAppMetadata ele : apps) {
            this.apps.add(ele);
        }
        return this;
    }

    public ListAppsResult withApps(Collection<SimulationAppMetadata> apps) {
        this.setApps(apps);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAppsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApps() != null) {
            sb.append("Apps: ").append(this.getApps()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResult)) {
            return false;
        }
        ListAppsResult other = (ListAppsResult)obj;
        if (other.getApps() == null ^ this.getApps() == null) {
            return false;
        }
        if (other.getApps() != null && !other.getApps().equals(this.getApps())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApps() == null ? 0 : this.getApps().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAppsResult clone() {
        try {
            return (ListAppsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

