/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private String itemName;
    private SdkInternalList<ReplaceableAttribute> attributes;
    private UpdateCondition expected;

    public PutAttributesRequest() {
    }

    public PutAttributesRequest(String domainName, String itemName, List<ReplaceableAttribute> attributes) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
    }

    public PutAttributesRequest(String domainName, String itemName, List<ReplaceableAttribute> attributes, UpdateCondition expected) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
        this.setExpected(expected);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public PutAttributesRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public PutAttributesRequest withItemName(String itemName) {
        this.setItemName(itemName);
        return this;
    }

    public List<ReplaceableAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalList();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<ReplaceableAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new SdkInternalList(attributes);
    }

    public PutAttributesRequest withAttributes(ReplaceableAttribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes((Collection<ReplaceableAttribute>)new SdkInternalList(attributes.length));
        }
        for (ReplaceableAttribute ele : attributes) {
            this.attributes.add((Object)ele);
        }
        return this;
    }

    public PutAttributesRequest withAttributes(Collection<ReplaceableAttribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void setExpected(UpdateCondition expected) {
        this.expected = expected;
    }

    public UpdateCondition getExpected() {
        return this.expected;
    }

    public PutAttributesRequest withExpected(UpdateCondition expected) {
        this.setExpected(expected);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItemName() != null) {
            sb.append("ItemName: " + this.getItemName() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getExpected() != null) {
            sb.append("Expected: " + this.getExpected());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAttributesRequest)) {
            return false;
        }
        PutAttributesRequest other = (PutAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItemName() == null ^ this.getItemName() == null) {
            return false;
        }
        if (other.getItemName() != null && !other.getItemName().equals(this.getItemName())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        return other.getExpected() == null || other.getExpected().equals(this.getExpected());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItemName() == null ? 0 : this.getItemName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getExpected() == null ? 0 : this.getExpected().hashCode());
        return hashCode;
    }

    public PutAttributesRequest clone() {
        return (PutAttributesRequest)super.clone();
    }
}

