/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class BatchPutAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private SdkInternalList<ReplaceableItem> items;

    public BatchPutAttributesRequest() {
    }

    public BatchPutAttributesRequest(String domainName, List<ReplaceableItem> items) {
        this.setDomainName(domainName);
        this.setItems(items);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public BatchPutAttributesRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public List<ReplaceableItem> getItems() {
        if (this.items == null) {
            this.items = new SdkInternalList();
        }
        return this.items;
    }

    public void setItems(Collection<ReplaceableItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new SdkInternalList(items);
    }

    public BatchPutAttributesRequest withItems(ReplaceableItem ... items) {
        if (this.items == null) {
            this.setItems((Collection<ReplaceableItem>)new SdkInternalList(items.length));
        }
        for (ReplaceableItem ele : items) {
            this.items.add((Object)ele);
        }
        return this;
    }

    public BatchPutAttributesRequest withItems(Collection<ReplaceableItem> items) {
        this.setItems(items);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutAttributesRequest)) {
            return false;
        }
        BatchPutAttributesRequest other = (BatchPutAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    public BatchPutAttributesRequest clone() {
        return (BatchPutAttributesRequest)super.clone();
    }
}

