/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteAttributesRequestMarshaller
implements Marshaller<Request<DeleteAttributesRequest>, DeleteAttributesRequest> {
    public Request<DeleteAttributesRequest> marshall(DeleteAttributesRequest deleteAttributesRequest) {
        UpdateCondition expected;
        SdkInternalList attributesList;
        if (deleteAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "DeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)deleteAttributesRequest.getDomainName()));
        }
        if (deleteAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString((String)deleteAttributesRequest.getItemName()));
        }
        if (!(attributesList = (SdkInternalList)deleteAttributesRequest.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
            int attributesListIndex = 1;
            for (Attribute attributesListValue : attributesList) {
                if (attributesListValue.getName() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)attributesListValue.getName()));
                }
                if (attributesListValue.getAlternateNameEncoding() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString((String)attributesListValue.getAlternateNameEncoding()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)attributesListValue.getValue()));
                }
                if (attributesListValue.getAlternateValueEncoding() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString((String)attributesListValue.getAlternateValueEncoding()));
                }
                ++attributesListIndex;
            }
        }
        if ((expected = deleteAttributesRequest.getExpected()) != null) {
            if (expected.getName() != null) {
                request.addParameter("Expected.Name", StringUtils.fromString((String)expected.getName()));
            }
            if (expected.getValue() != null) {
                request.addParameter("Expected.Value", StringUtils.fromString((String)expected.getValue()));
            }
            if (expected.getExists() != null) {
                request.addParameter("Expected.Exists", StringUtils.fromBoolean((Boolean)expected.getExists()));
            }
        }
        return request;
    }
}

