/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.signer.model.SigningMaterial;
import com.amazonaws.services.signer.model.SigningPlatformOverrides;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutSigningProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String profileName;
    private SigningMaterial signingMaterial;
    private String platformId;
    private SigningPlatformOverrides overrides;
    private Map<String, String> signingParameters;
    private Map<String, String> tags;

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public PutSigningProfileRequest withProfileName(String profileName) {
        this.setProfileName(profileName);
        return this;
    }

    public void setSigningMaterial(SigningMaterial signingMaterial) {
        this.signingMaterial = signingMaterial;
    }

    public SigningMaterial getSigningMaterial() {
        return this.signingMaterial;
    }

    public PutSigningProfileRequest withSigningMaterial(SigningMaterial signingMaterial) {
        this.setSigningMaterial(signingMaterial);
        return this;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public PutSigningProfileRequest withPlatformId(String platformId) {
        this.setPlatformId(platformId);
        return this;
    }

    public void setOverrides(SigningPlatformOverrides overrides) {
        this.overrides = overrides;
    }

    public SigningPlatformOverrides getOverrides() {
        return this.overrides;
    }

    public PutSigningProfileRequest withOverrides(SigningPlatformOverrides overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public Map<String, String> getSigningParameters() {
        return this.signingParameters;
    }

    public void setSigningParameters(Map<String, String> signingParameters) {
        this.signingParameters = signingParameters;
    }

    public PutSigningProfileRequest withSigningParameters(Map<String, String> signingParameters) {
        this.setSigningParameters(signingParameters);
        return this;
    }

    public PutSigningProfileRequest addSigningParametersEntry(String key, String value) {
        if (null == this.signingParameters) {
            this.signingParameters = new HashMap<String, String>();
        }
        if (this.signingParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.signingParameters.put(key, value);
        return this;
    }

    public PutSigningProfileRequest clearSigningParametersEntries() {
        this.signingParameters = null;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public PutSigningProfileRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public PutSigningProfileRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public PutSigningProfileRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfileName() != null) {
            sb.append("ProfileName: ").append(this.getProfileName()).append(",");
        }
        if (this.getSigningMaterial() != null) {
            sb.append("SigningMaterial: ").append(this.getSigningMaterial()).append(",");
        }
        if (this.getPlatformId() != null) {
            sb.append("PlatformId: ").append(this.getPlatformId()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getSigningParameters() != null) {
            sb.append("SigningParameters: ").append(this.getSigningParameters()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSigningProfileRequest)) {
            return false;
        }
        PutSigningProfileRequest other = (PutSigningProfileRequest)obj;
        if (other.getProfileName() == null ^ this.getProfileName() == null) {
            return false;
        }
        if (other.getProfileName() != null && !other.getProfileName().equals(this.getProfileName())) {
            return false;
        }
        if (other.getSigningMaterial() == null ^ this.getSigningMaterial() == null) {
            return false;
        }
        if (other.getSigningMaterial() != null && !other.getSigningMaterial().equals(this.getSigningMaterial())) {
            return false;
        }
        if (other.getPlatformId() == null ^ this.getPlatformId() == null) {
            return false;
        }
        if (other.getPlatformId() != null && !other.getPlatformId().equals(this.getPlatformId())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getSigningParameters() == null ^ this.getSigningParameters() == null) {
            return false;
        }
        if (other.getSigningParameters() != null && !other.getSigningParameters().equals(this.getSigningParameters())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfileName() == null ? 0 : this.getProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getSigningMaterial() == null ? 0 : this.getSigningMaterial().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformId() == null ? 0 : this.getPlatformId().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getSigningParameters() == null ? 0 : this.getSigningParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PutSigningProfileRequest clone() {
        return (PutSigningProfileRequest)super.clone();
    }
}

