/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.shield.model.ProtectedResourceType;
import com.amazonaws.services.shield.model.transform.InclusionProtectionFiltersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InclusionProtectionFilters
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> resourceArns;
    private List<String> protectionNames;
    private List<String> resourceTypes;

    public List<String> getResourceArns() {
        return this.resourceArns;
    }

    public void setResourceArns(Collection<String> resourceArns) {
        if (resourceArns == null) {
            this.resourceArns = null;
            return;
        }
        this.resourceArns = new ArrayList<String>(resourceArns);
    }

    public InclusionProtectionFilters withResourceArns(String ... resourceArns) {
        if (this.resourceArns == null) {
            this.setResourceArns(new ArrayList<String>(resourceArns.length));
        }
        for (String ele : resourceArns) {
            this.resourceArns.add(ele);
        }
        return this;
    }

    public InclusionProtectionFilters withResourceArns(Collection<String> resourceArns) {
        this.setResourceArns(resourceArns);
        return this;
    }

    public List<String> getProtectionNames() {
        return this.protectionNames;
    }

    public void setProtectionNames(Collection<String> protectionNames) {
        if (protectionNames == null) {
            this.protectionNames = null;
            return;
        }
        this.protectionNames = new ArrayList<String>(protectionNames);
    }

    public InclusionProtectionFilters withProtectionNames(String ... protectionNames) {
        if (this.protectionNames == null) {
            this.setProtectionNames(new ArrayList<String>(protectionNames.length));
        }
        for (String ele : protectionNames) {
            this.protectionNames.add(ele);
        }
        return this;
    }

    public InclusionProtectionFilters withProtectionNames(Collection<String> protectionNames) {
        this.setProtectionNames(protectionNames);
        return this;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public InclusionProtectionFilters withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public InclusionProtectionFilters withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public InclusionProtectionFilters withResourceTypes(ProtectedResourceType ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ProtectedResourceType value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArns() != null) {
            sb.append("ResourceArns: ").append(this.getResourceArns()).append(",");
        }
        if (this.getProtectionNames() != null) {
            sb.append("ProtectionNames: ").append(this.getProtectionNames()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InclusionProtectionFilters)) {
            return false;
        }
        InclusionProtectionFilters other = (InclusionProtectionFilters)obj;
        if (other.getResourceArns() == null ^ this.getResourceArns() == null) {
            return false;
        }
        if (other.getResourceArns() != null && !other.getResourceArns().equals(this.getResourceArns())) {
            return false;
        }
        if (other.getProtectionNames() == null ^ this.getProtectionNames() == null) {
            return false;
        }
        if (other.getProtectionNames() != null && !other.getProtectionNames().equals(this.getProtectionNames())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        return other.getResourceTypes() == null || other.getResourceTypes().equals(this.getResourceTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArns() == null ? 0 : this.getResourceArns().hashCode());
        hashCode = 31 * hashCode + (this.getProtectionNames() == null ? 0 : this.getProtectionNames().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        return hashCode;
    }

    public InclusionProtectionFilters clone() {
        try {
            return (InclusionProtectionFilters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InclusionProtectionFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

