/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.InsightsEvent;
import com.amazonaws.services.simpleemailv2.model.transform.EmailInsightsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EmailInsights
implements Serializable,
Cloneable,
StructuredPojo {
    private String destination;
    private String isp;
    private List<InsightsEvent> events;

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public EmailInsights withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getIsp() {
        return this.isp;
    }

    public EmailInsights withIsp(String isp) {
        this.setIsp(isp);
        return this;
    }

    public List<InsightsEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<InsightsEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<InsightsEvent>(events);
    }

    public EmailInsights withEvents(InsightsEvent ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<InsightsEvent>(events.length));
        }
        for (InsightsEvent ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public EmailInsights withEvents(Collection<InsightsEvent> events) {
        this.setEvents(events);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestination() != null) {
            sb.append("Destination: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIsp() != null) {
            sb.append("Isp: ").append(this.getIsp()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailInsights)) {
            return false;
        }
        EmailInsights other = (EmailInsights)obj;
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getIsp() == null ^ this.getIsp() == null) {
            return false;
        }
        if (other.getIsp() != null && !other.getIsp().equals(this.getIsp())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getIsp() == null ? 0 : this.getIsp().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public EmailInsights clone() {
        try {
            return (EmailInsights)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmailInsightsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

