/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.DataFormat;
import com.amazonaws.services.simpleemailv2.model.transform.ImportDataSourceMarshaller;
import java.io.Serializable;

public class ImportDataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Url;
    private String dataFormat;

    public void setS3Url(String s3Url) {
        this.s3Url = s3Url;
    }

    public String getS3Url() {
        return this.s3Url;
    }

    public ImportDataSource withS3Url(String s3Url) {
        this.setS3Url(s3Url);
        return this;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public ImportDataSource withDataFormat(String dataFormat) {
        this.setDataFormat(dataFormat);
        return this;
    }

    public ImportDataSource withDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Url() != null) {
            sb.append("S3Url: ").append(this.getS3Url()).append(",");
        }
        if (this.getDataFormat() != null) {
            sb.append("DataFormat: ").append(this.getDataFormat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDataSource)) {
            return false;
        }
        ImportDataSource other = (ImportDataSource)obj;
        if (other.getS3Url() == null ^ this.getS3Url() == null) {
            return false;
        }
        if (other.getS3Url() != null && !other.getS3Url().equals(this.getS3Url())) {
            return false;
        }
        if (other.getDataFormat() == null ^ this.getDataFormat() == null) {
            return false;
        }
        return other.getDataFormat() == null || other.getDataFormat().equals(this.getDataFormat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Url() == null ? 0 : this.getS3Url().hashCode());
        hashCode = 31 * hashCode + (this.getDataFormat() == null ? 0 : this.getDataFormat().hashCode());
        return hashCode;
    }

    public ImportDataSource clone() {
        try {
            return (ImportDataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImportDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

