/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.DomainIspPlacement;
import com.amazonaws.services.simpleemailv2.model.VolumeStatistics;
import com.amazonaws.services.simpleemailv2.model.transform.DailyVolumeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DailyVolume
implements Serializable,
Cloneable,
StructuredPojo {
    private Date startDate;
    private VolumeStatistics volumeStatistics;
    private List<DomainIspPlacement> domainIspPlacements;

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public DailyVolume withStartDate(Date startDate) {
        this.setStartDate(startDate);
        return this;
    }

    public void setVolumeStatistics(VolumeStatistics volumeStatistics) {
        this.volumeStatistics = volumeStatistics;
    }

    public VolumeStatistics getVolumeStatistics() {
        return this.volumeStatistics;
    }

    public DailyVolume withVolumeStatistics(VolumeStatistics volumeStatistics) {
        this.setVolumeStatistics(volumeStatistics);
        return this;
    }

    public List<DomainIspPlacement> getDomainIspPlacements() {
        return this.domainIspPlacements;
    }

    public void setDomainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
        if (domainIspPlacements == null) {
            this.domainIspPlacements = null;
            return;
        }
        this.domainIspPlacements = new ArrayList<DomainIspPlacement>(domainIspPlacements);
    }

    public DailyVolume withDomainIspPlacements(DomainIspPlacement ... domainIspPlacements) {
        if (this.domainIspPlacements == null) {
            this.setDomainIspPlacements(new ArrayList<DomainIspPlacement>(domainIspPlacements.length));
        }
        for (DomainIspPlacement ele : domainIspPlacements) {
            this.domainIspPlacements.add(ele);
        }
        return this;
    }

    public DailyVolume withDomainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
        this.setDomainIspPlacements(domainIspPlacements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartDate() != null) {
            sb.append("StartDate: ").append(this.getStartDate()).append(",");
        }
        if (this.getVolumeStatistics() != null) {
            sb.append("VolumeStatistics: ").append(this.getVolumeStatistics()).append(",");
        }
        if (this.getDomainIspPlacements() != null) {
            sb.append("DomainIspPlacements: ").append(this.getDomainIspPlacements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DailyVolume)) {
            return false;
        }
        DailyVolume other = (DailyVolume)obj;
        if (other.getStartDate() == null ^ this.getStartDate() == null) {
            return false;
        }
        if (other.getStartDate() != null && !other.getStartDate().equals(this.getStartDate())) {
            return false;
        }
        if (other.getVolumeStatistics() == null ^ this.getVolumeStatistics() == null) {
            return false;
        }
        if (other.getVolumeStatistics() != null && !other.getVolumeStatistics().equals(this.getVolumeStatistics())) {
            return false;
        }
        if (other.getDomainIspPlacements() == null ^ this.getDomainIspPlacements() == null) {
            return false;
        }
        return other.getDomainIspPlacements() == null || other.getDomainIspPlacements().equals(this.getDomainIspPlacements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartDate() == null ? 0 : this.getStartDate().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeStatistics() == null ? 0 : this.getVolumeStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIspPlacements() == null ? 0 : this.getDomainIspPlacements().hashCode());
        return hashCode;
    }

    public DailyVolume clone() {
        try {
            return (DailyVolume)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DailyVolumeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

