/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.servicediscovery.AWSServiceDiscovery;
import com.amazonaws.services.servicediscovery.AWSServiceDiscoveryClientBuilder;
import com.amazonaws.services.servicediscovery.model.AWSServiceDiscoveryException;
import com.amazonaws.services.servicediscovery.model.CreateHttpNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreateHttpNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreatePrivateDnsNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.CreatePublicDnsNamespaceResult;
import com.amazonaws.services.servicediscovery.model.CreateServiceRequest;
import com.amazonaws.services.servicediscovery.model.CreateServiceResult;
import com.amazonaws.services.servicediscovery.model.DeleteNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.DeleteNamespaceResult;
import com.amazonaws.services.servicediscovery.model.DeleteServiceRequest;
import com.amazonaws.services.servicediscovery.model.DeleteServiceResult;
import com.amazonaws.services.servicediscovery.model.DeregisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.DeregisterInstanceResult;
import com.amazonaws.services.servicediscovery.model.DiscoverInstancesRequest;
import com.amazonaws.services.servicediscovery.model.DiscoverInstancesResult;
import com.amazonaws.services.servicediscovery.model.GetInstanceRequest;
import com.amazonaws.services.servicediscovery.model.GetInstanceResult;
import com.amazonaws.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import com.amazonaws.services.servicediscovery.model.GetInstancesHealthStatusResult;
import com.amazonaws.services.servicediscovery.model.GetNamespaceRequest;
import com.amazonaws.services.servicediscovery.model.GetNamespaceResult;
import com.amazonaws.services.servicediscovery.model.GetOperationRequest;
import com.amazonaws.services.servicediscovery.model.GetOperationResult;
import com.amazonaws.services.servicediscovery.model.GetServiceRequest;
import com.amazonaws.services.servicediscovery.model.GetServiceResult;
import com.amazonaws.services.servicediscovery.model.ListInstancesRequest;
import com.amazonaws.services.servicediscovery.model.ListInstancesResult;
import com.amazonaws.services.servicediscovery.model.ListNamespacesRequest;
import com.amazonaws.services.servicediscovery.model.ListNamespacesResult;
import com.amazonaws.services.servicediscovery.model.ListOperationsRequest;
import com.amazonaws.services.servicediscovery.model.ListOperationsResult;
import com.amazonaws.services.servicediscovery.model.ListServicesRequest;
import com.amazonaws.services.servicediscovery.model.ListServicesResult;
import com.amazonaws.services.servicediscovery.model.ListTagsForResourceRequest;
import com.amazonaws.services.servicediscovery.model.ListTagsForResourceResult;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceRequest;
import com.amazonaws.services.servicediscovery.model.RegisterInstanceResult;
import com.amazonaws.services.servicediscovery.model.TagResourceRequest;
import com.amazonaws.services.servicediscovery.model.TagResourceResult;
import com.amazonaws.services.servicediscovery.model.UntagResourceRequest;
import com.amazonaws.services.servicediscovery.model.UntagResourceResult;
import com.amazonaws.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;
import com.amazonaws.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResult;
import com.amazonaws.services.servicediscovery.model.UpdateServiceRequest;
import com.amazonaws.services.servicediscovery.model.UpdateServiceResult;
import com.amazonaws.services.servicediscovery.model.transform.CreateHttpNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreateHttpNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreatePrivateDnsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreatePrivateDnsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreatePublicDnsNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreatePublicDnsNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreateServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CreateServiceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.CustomHealthNotFoundExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeleteServiceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeregisterInstanceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DeregisterInstanceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DiscoverInstancesRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DiscoverInstancesResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.DuplicateRequestExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstanceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstanceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstancesHealthStatusRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetInstancesHealthStatusResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetNamespaceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetNamespaceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetOperationRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetOperationResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.GetServiceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.InstanceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListInstancesRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListInstancesResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListNamespacesRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListNamespacesResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListOperationsRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListOperationsResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListServicesRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListServicesResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.NamespaceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.NamespaceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.OperationNotFoundExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.RegisterInstanceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.RegisterInstanceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.RequestLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ResourceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ServiceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.ServiceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateInstanceCustomHealthStatusRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateInstanceCustomHealthStatusResultJsonUnmarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateServiceRequestProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.transform.UpdateServiceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSServiceDiscoveryClient
extends AmazonWebServiceClient
implements AWSServiceDiscovery {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSServiceDiscovery.class);
    private static final String DEFAULT_SIGNING_NAME = "servicediscovery";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotFound").withExceptionUnmarshaller((JsonErrorUnmarshaller)OperationNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestLimitExceeded").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUse").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withExceptionUnmarshaller((JsonErrorUnmarshaller)DuplicateRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInput").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidInputExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceAlreadyExists").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceNotFound").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NamespaceAlreadyExists").withExceptionUnmarshaller((JsonErrorUnmarshaller)NamespaceAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InstanceNotFound").withExceptionUnmarshaller((JsonErrorUnmarshaller)InstanceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NamespaceNotFound").withExceptionUnmarshaller((JsonErrorUnmarshaller)NamespaceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CustomHealthNotFound").withExceptionUnmarshaller((JsonErrorUnmarshaller)CustomHealthNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceeded").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceLimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSServiceDiscoveryException.class));

    public static AWSServiceDiscoveryClientBuilder builder() {
        return AWSServiceDiscoveryClientBuilder.standard();
    }

    AWSServiceDiscoveryClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSServiceDiscoveryClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("servicediscovery.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/servicediscovery/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/servicediscovery/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateHttpNamespaceResult createHttpNamespace(CreateHttpNamespaceRequest request) {
        request = (CreateHttpNamespaceRequest)this.beforeClientExecution(request);
        return this.executeCreateHttpNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHttpNamespaceResult executeCreateHttpNamespace(CreateHttpNamespaceRequest createHttpNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHttpNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHttpNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHttpNamespaceRequestProtocolMarshaller(protocolFactory).marshall((CreateHttpNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHttpNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHttpNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHttpNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHttpNamespaceResult createHttpNamespaceResult = (CreateHttpNamespaceResult)response.getAwsResponse();
            return createHttpNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePrivateDnsNamespaceResult createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest request) {
        request = (CreatePrivateDnsNamespaceRequest)this.beforeClientExecution(request);
        return this.executeCreatePrivateDnsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePrivateDnsNamespaceResult executeCreatePrivateDnsNamespace(CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPrivateDnsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePrivateDnsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePrivateDnsNamespaceRequestProtocolMarshaller(protocolFactory).marshall((CreatePrivateDnsNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPrivateDnsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePrivateDnsNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePrivateDnsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePrivateDnsNamespaceResult createPrivateDnsNamespaceResult = (CreatePrivateDnsNamespaceResult)response.getAwsResponse();
            return createPrivateDnsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePublicDnsNamespaceResult createPublicDnsNamespace(CreatePublicDnsNamespaceRequest request) {
        request = (CreatePublicDnsNamespaceRequest)this.beforeClientExecution(request);
        return this.executeCreatePublicDnsNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePublicDnsNamespaceResult executeCreatePublicDnsNamespace(CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPublicDnsNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePublicDnsNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePublicDnsNamespaceRequestProtocolMarshaller(protocolFactory).marshall((CreatePublicDnsNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPublicDnsNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePublicDnsNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePublicDnsNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePublicDnsNamespaceResult createPublicDnsNamespaceResult = (CreatePublicDnsNamespaceResult)response.getAwsResponse();
            return createPublicDnsNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateServiceResult createService(CreateServiceRequest request) {
        request = (CreateServiceRequest)this.beforeClientExecution(request);
        return this.executeCreateService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateServiceResult executeCreateService(CreateServiceRequest createServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServiceRequestProtocolMarshaller(protocolFactory).marshall((CreateServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateServiceResult createServiceResult = (CreateServiceResult)response.getAwsResponse();
            return createServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        request = (DeleteNamespaceRequest)this.beforeClientExecution(request);
        return this.executeDeleteNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNamespaceResult executeDeleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNamespaceRequestProtocolMarshaller(protocolFactory).marshall((DeleteNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNamespaceResult deleteNamespaceResult = (DeleteNamespaceResult)response.getAwsResponse();
            return deleteNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteServiceResult deleteService(DeleteServiceRequest request) {
        request = (DeleteServiceRequest)this.beforeClientExecution(request);
        return this.executeDeleteService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteServiceResult executeDeleteService(DeleteServiceRequest deleteServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServiceRequestProtocolMarshaller(protocolFactory).marshall((DeleteServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServiceResult deleteServiceResult = (DeleteServiceResult)response.getAwsResponse();
            return deleteServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterInstanceResult deregisterInstance(DeregisterInstanceRequest request) {
        request = (DeregisterInstanceRequest)this.beforeClientExecution(request);
        return this.executeDeregisterInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterInstanceResult executeDeregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterInstanceRequestProtocolMarshaller(protocolFactory).marshall((DeregisterInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterInstanceResult deregisterInstanceResult = (DeregisterInstanceResult)response.getAwsResponse();
            return deregisterInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DiscoverInstancesResult discoverInstances(DiscoverInstancesRequest request) {
        request = (DiscoverInstancesRequest)this.beforeClientExecution(request);
        return this.executeDiscoverInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DiscoverInstancesResult executeDiscoverInstances(DiscoverInstancesRequest discoverInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(discoverInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DiscoverInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DiscoverInstancesRequestProtocolMarshaller(protocolFactory).marshall((DiscoverInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)discoverInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DiscoverInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "data-";
                String resolvedHostPrefix = String.format("data-", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DiscoverInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DiscoverInstancesResult discoverInstancesResult = (DiscoverInstancesResult)response.getAwsResponse();
            return discoverInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInstanceResult getInstance(GetInstanceRequest request) {
        request = (GetInstanceRequest)this.beforeClientExecution(request);
        return this.executeGetInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInstanceResult executeGetInstance(GetInstanceRequest getInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInstanceRequestProtocolMarshaller(protocolFactory).marshall((GetInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInstanceResult getInstanceResult = (GetInstanceResult)response.getAwsResponse();
            return getInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInstancesHealthStatusResult getInstancesHealthStatus(GetInstancesHealthStatusRequest request) {
        request = (GetInstancesHealthStatusRequest)this.beforeClientExecution(request);
        return this.executeGetInstancesHealthStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInstancesHealthStatusResult executeGetInstancesHealthStatus(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInstancesHealthStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInstancesHealthStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInstancesHealthStatusRequestProtocolMarshaller(protocolFactory).marshall((GetInstancesHealthStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInstancesHealthStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInstancesHealthStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInstancesHealthStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInstancesHealthStatusResult getInstancesHealthStatusResult = (GetInstancesHealthStatusResult)response.getAwsResponse();
            return getInstancesHealthStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        request = (GetNamespaceRequest)this.beforeClientExecution(request);
        return this.executeGetNamespace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNamespaceResult executeGetNamespace(GetNamespaceRequest getNamespaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNamespaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNamespaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNamespaceRequestProtocolMarshaller(protocolFactory).marshall((GetNamespaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNamespaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNamespace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNamespaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNamespaceResult getNamespaceResult = (GetNamespaceResult)response.getAwsResponse();
            return getNamespaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOperationResult getOperation(GetOperationRequest request) {
        request = (GetOperationRequest)this.beforeClientExecution(request);
        return this.executeGetOperation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOperationResult executeGetOperation(GetOperationRequest getOperationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOperationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOperationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOperationRequestProtocolMarshaller(protocolFactory).marshall((GetOperationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOperationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOperation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOperationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOperationResult getOperationResult = (GetOperationResult)response.getAwsResponse();
            return getOperationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServiceResult getService(GetServiceRequest request) {
        request = (GetServiceRequest)this.beforeClientExecution(request);
        return this.executeGetService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServiceResult executeGetService(GetServiceRequest getServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServiceRequestProtocolMarshaller(protocolFactory).marshall((GetServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServiceResult getServiceResult = (GetServiceResult)response.getAwsResponse();
            return getServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInstancesResult listInstances(ListInstancesRequest request) {
        request = (ListInstancesRequest)this.beforeClientExecution(request);
        return this.executeListInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInstancesResult executeListInstances(ListInstancesRequest listInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstancesRequestProtocolMarshaller(protocolFactory).marshall((ListInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInstancesResult listInstancesResult = (ListInstancesResult)response.getAwsResponse();
            return listInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNamespacesResult listNamespaces(ListNamespacesRequest request) {
        request = (ListNamespacesRequest)this.beforeClientExecution(request);
        return this.executeListNamespaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNamespacesResult executeListNamespaces(ListNamespacesRequest listNamespacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNamespacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNamespacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNamespacesRequestProtocolMarshaller(protocolFactory).marshall((ListNamespacesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNamespacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNamespaces");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNamespacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNamespacesResult listNamespacesResult = (ListNamespacesResult)response.getAwsResponse();
            return listNamespacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOperationsResult listOperations(ListOperationsRequest request) {
        request = (ListOperationsRequest)this.beforeClientExecution(request);
        return this.executeListOperations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOperationsResult executeListOperations(ListOperationsRequest listOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOperationsRequestProtocolMarshaller(protocolFactory).marshall((ListOperationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOperationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOperations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOperationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOperationsResult listOperationsResult = (ListOperationsResult)response.getAwsResponse();
            return listOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServicesResult listServices(ListServicesRequest request) {
        request = (ListServicesRequest)this.beforeClientExecution(request);
        return this.executeListServices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListServicesResult executeListServices(ListServicesRequest listServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServicesRequestProtocolMarshaller(protocolFactory).marshall((ListServicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listServicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListServices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListServicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListServicesResult listServicesResult = (ListServicesResult)response.getAwsResponse();
            return listServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterInstanceResult registerInstance(RegisterInstanceRequest request) {
        request = (RegisterInstanceRequest)this.beforeClientExecution(request);
        return this.executeRegisterInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterInstanceResult executeRegisterInstance(RegisterInstanceRequest registerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterInstanceRequestProtocolMarshaller(protocolFactory).marshall((RegisterInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterInstanceResult registerInstanceResult = (RegisterInstanceResult)response.getAwsResponse();
            return registerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInstanceCustomHealthStatusResult updateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest request) {
        request = (UpdateInstanceCustomHealthStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateInstanceCustomHealthStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInstanceCustomHealthStatusResult executeUpdateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest updateInstanceCustomHealthStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInstanceCustomHealthStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInstanceCustomHealthStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInstanceCustomHealthStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdateInstanceCustomHealthStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateInstanceCustomHealthStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateInstanceCustomHealthStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateInstanceCustomHealthStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInstanceCustomHealthStatusResult updateInstanceCustomHealthStatusResult = (UpdateInstanceCustomHealthStatusResult)response.getAwsResponse();
            return updateInstanceCustomHealthStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServiceResult updateService(UpdateServiceRequest request) {
        request = (UpdateServiceRequest)this.beforeClientExecution(request);
        return this.executeUpdateService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServiceResult executeUpdateService(UpdateServiceRequest updateServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceRequestProtocolMarshaller(protocolFactory).marshall((UpdateServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ServiceDiscovery");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceResult updateServiceResult = (UpdateServiceResult)response.getAwsResponse();
            return updateServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

