/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPrincipalsForPortfolioRequestMarshaller
implements Marshaller<Request<ListPrincipalsForPortfolioRequest>, ListPrincipalsForPortfolioRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListPrincipalsForPortfolioRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListPrincipalsForPortfolioRequest> marshall(ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) {
        if (listPrincipalsForPortfolioRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPrincipalsForPortfolioRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ListPrincipalsForPortfolio");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listPrincipalsForPortfolioRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(listPrincipalsForPortfolioRequest.getAcceptLanguage());
            }
            if (listPrincipalsForPortfolioRequest.getPortfolioId() != null) {
                jsonGenerator.writeFieldName("PortfolioId").writeValue(listPrincipalsForPortfolioRequest.getPortfolioId());
            }
            if (listPrincipalsForPortfolioRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(listPrincipalsForPortfolioRequest.getPageSize().intValue());
            }
            if (listPrincipalsForPortfolioRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(listPrincipalsForPortfolioRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

