/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.DescribeRecordRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeRecordRequestMarshaller
implements Marshaller<Request<DescribeRecordRequest>, DescribeRecordRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeRecordRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeRecordRequest> marshall(DescribeRecordRequest describeRecordRequest) {
        if (describeRecordRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRecordRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.DescribeRecord");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeRecordRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(describeRecordRequest.getAcceptLanguage());
            }
            if (describeRecordRequest.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(describeRecordRequest.getId());
            }
            if (describeRecordRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(describeRecordRequest.getPageToken());
            }
            if (describeRecordRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(describeRecordRequest.getPageSize().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

