/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.servicecatalog.model.ServiceActionDefinitionType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateServiceActionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String definitionType;
    private Map<String, String> definition;
    private String description;
    private String acceptLanguage;
    private String idempotencyToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateServiceActionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDefinitionType(String definitionType) {
        this.definitionType = definitionType;
    }

    public String getDefinitionType() {
        return this.definitionType;
    }

    public CreateServiceActionRequest withDefinitionType(String definitionType) {
        this.setDefinitionType(definitionType);
        return this;
    }

    public CreateServiceActionRequest withDefinitionType(ServiceActionDefinitionType definitionType) {
        this.definitionType = definitionType.toString();
        return this;
    }

    public Map<String, String> getDefinition() {
        return this.definition;
    }

    public void setDefinition(Map<String, String> definition) {
        this.definition = definition;
    }

    public CreateServiceActionRequest withDefinition(Map<String, String> definition) {
        this.setDefinition(definition);
        return this;
    }

    public CreateServiceActionRequest addDefinitionEntry(String key, String value) {
        if (null == this.definition) {
            this.definition = new HashMap<String, String>();
        }
        if (this.definition.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.definition.put(key, value);
        return this;
    }

    public CreateServiceActionRequest clearDefinitionEntries() {
        this.definition = null;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateServiceActionRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public CreateServiceActionRequest withAcceptLanguage(String acceptLanguage) {
        this.setAcceptLanguage(acceptLanguage);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreateServiceActionRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDefinitionType() != null) {
            sb.append("DefinitionType: ").append(this.getDefinitionType()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append(this.getDefinition()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getAcceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.getAcceptLanguage()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceActionRequest)) {
            return false;
        }
        CreateServiceActionRequest other = (CreateServiceActionRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDefinitionType() == null ^ this.getDefinitionType() == null) {
            return false;
        }
        if (other.getDefinitionType() != null && !other.getDefinitionType().equals(this.getDefinitionType())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        if (other.getDefinition() != null && !other.getDefinition().equals(this.getDefinition())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getAcceptLanguage() == null ^ this.getAcceptLanguage() == null) {
            return false;
        }
        if (other.getAcceptLanguage() != null && !other.getAcceptLanguage().equals(this.getAcceptLanguage())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        return other.getIdempotencyToken() == null || other.getIdempotencyToken().equals(this.getIdempotencyToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDefinitionType() == null ? 0 : this.getDefinitionType().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAcceptLanguage() == null ? 0 : this.getAcceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        return hashCode;
    }

    public CreateServiceActionRequest clone() {
        return (CreateServiceActionRequest)super.clone();
    }
}

