/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ScanProvisionedProductsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ScanProvisionedProductsRequestMarshaller
implements Marshaller<Request<ScanProvisionedProductsRequest>, ScanProvisionedProductsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ScanProvisionedProductsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ScanProvisionedProductsRequest> marshall(ScanProvisionedProductsRequest scanProvisionedProductsRequest) {
        if (scanProvisionedProductsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)scanProvisionedProductsRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ScanProvisionedProducts");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (scanProvisionedProductsRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(scanProvisionedProductsRequest.getAcceptLanguage());
            }
            if (scanProvisionedProductsRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(scanProvisionedProductsRequest.getPageSize().intValue());
            }
            if (scanProvisionedProductsRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(scanProvisionedProductsRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

