/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.LogSourceResource;
import com.amazonaws.services.securitylake.model.transform.LogSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String account;
    private String region;
    private List<LogSourceResource> sources;

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }

    public LogSource withAccount(String account) {
        this.setAccount(account);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public LogSource withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public List<LogSourceResource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<LogSourceResource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<LogSourceResource>(sources);
    }

    public LogSource withSources(LogSourceResource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<LogSourceResource>(sources.length));
        }
        for (LogSourceResource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public LogSource withSources(Collection<LogSourceResource> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccount() != null) {
            sb.append("Account: ").append(this.getAccount()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSource)) {
            return false;
        }
        LogSource other = (LogSource)obj;
        if (other.getAccount() == null ^ this.getAccount() == null) {
            return false;
        }
        if (other.getAccount() != null && !other.getAccount().equals(this.getAccount())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccount() == null ? 0 : this.getAccount().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public LogSource clone() {
        try {
            return (LogSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

