/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securitylake.model.DataLakeException;
import java.util.Date;

@SdkInternalApi
public class DataLakeExceptionMarshaller {
    private static final MarshallingInfo<String> EXCEPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exception").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<String> REMEDIATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remediation").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").timestampFormat("iso8601").build();
    private static final DataLakeExceptionMarshaller instance = new DataLakeExceptionMarshaller();

    public static DataLakeExceptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataLakeException dataLakeException, ProtocolMarshaller protocolMarshaller) {
        if (dataLakeException == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataLakeException.getException(), EXCEPTION_BINDING);
            protocolMarshaller.marshall((Object)dataLakeException.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall((Object)dataLakeException.getRemediation(), REMEDIATION_BINDING);
            protocolMarshaller.marshall((Object)dataLakeException.getTimestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

