/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.transform.DataLakeReplicationConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataLakeReplicationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> regions;
    private String roleArn;

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<String>(regions);
    }

    public DataLakeReplicationConfiguration withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<String>(regions.length));
        }
        for (String ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public DataLakeReplicationConfiguration withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public DataLakeReplicationConfiguration withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeReplicationConfiguration)) {
            return false;
        }
        DataLakeReplicationConfiguration other = (DataLakeReplicationConfiguration)obj;
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        if (other.getRegions() != null && !other.getRegions().equals(this.getRegions())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        return other.getRoleArn() == null || other.getRoleArn().equals(this.getRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        return hashCode;
    }

    public DataLakeReplicationConfiguration clone() {
        try {
            return (DataLakeReplicationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataLakeReplicationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

