/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.securitylake.AmazonSecurityLake;
import com.amazonaws.services.securitylake.AmazonSecurityLakeClientBuilder;
import com.amazonaws.services.securitylake.model.AmazonSecurityLakeException;
import com.amazonaws.services.securitylake.model.CreateAwsLogSourceRequest;
import com.amazonaws.services.securitylake.model.CreateAwsLogSourceResult;
import com.amazonaws.services.securitylake.model.CreateCustomLogSourceRequest;
import com.amazonaws.services.securitylake.model.CreateCustomLogSourceResult;
import com.amazonaws.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest;
import com.amazonaws.services.securitylake.model.CreateDataLakeExceptionSubscriptionResult;
import com.amazonaws.services.securitylake.model.CreateDataLakeOrganizationConfigurationRequest;
import com.amazonaws.services.securitylake.model.CreateDataLakeOrganizationConfigurationResult;
import com.amazonaws.services.securitylake.model.CreateDataLakeRequest;
import com.amazonaws.services.securitylake.model.CreateDataLakeResult;
import com.amazonaws.services.securitylake.model.CreateSubscriberNotificationRequest;
import com.amazonaws.services.securitylake.model.CreateSubscriberNotificationResult;
import com.amazonaws.services.securitylake.model.CreateSubscriberRequest;
import com.amazonaws.services.securitylake.model.CreateSubscriberResult;
import com.amazonaws.services.securitylake.model.DeleteAwsLogSourceRequest;
import com.amazonaws.services.securitylake.model.DeleteAwsLogSourceResult;
import com.amazonaws.services.securitylake.model.DeleteCustomLogSourceRequest;
import com.amazonaws.services.securitylake.model.DeleteCustomLogSourceResult;
import com.amazonaws.services.securitylake.model.DeleteDataLakeExceptionSubscriptionRequest;
import com.amazonaws.services.securitylake.model.DeleteDataLakeExceptionSubscriptionResult;
import com.amazonaws.services.securitylake.model.DeleteDataLakeOrganizationConfigurationRequest;
import com.amazonaws.services.securitylake.model.DeleteDataLakeOrganizationConfigurationResult;
import com.amazonaws.services.securitylake.model.DeleteDataLakeRequest;
import com.amazonaws.services.securitylake.model.DeleteDataLakeResult;
import com.amazonaws.services.securitylake.model.DeleteSubscriberNotificationRequest;
import com.amazonaws.services.securitylake.model.DeleteSubscriberNotificationResult;
import com.amazonaws.services.securitylake.model.DeleteSubscriberRequest;
import com.amazonaws.services.securitylake.model.DeleteSubscriberResult;
import com.amazonaws.services.securitylake.model.DeregisterDataLakeDelegatedAdministratorRequest;
import com.amazonaws.services.securitylake.model.DeregisterDataLakeDelegatedAdministratorResult;
import com.amazonaws.services.securitylake.model.GetDataLakeExceptionSubscriptionRequest;
import com.amazonaws.services.securitylake.model.GetDataLakeExceptionSubscriptionResult;
import com.amazonaws.services.securitylake.model.GetDataLakeOrganizationConfigurationRequest;
import com.amazonaws.services.securitylake.model.GetDataLakeOrganizationConfigurationResult;
import com.amazonaws.services.securitylake.model.GetDataLakeSourcesRequest;
import com.amazonaws.services.securitylake.model.GetDataLakeSourcesResult;
import com.amazonaws.services.securitylake.model.GetSubscriberRequest;
import com.amazonaws.services.securitylake.model.GetSubscriberResult;
import com.amazonaws.services.securitylake.model.ListDataLakeExceptionsRequest;
import com.amazonaws.services.securitylake.model.ListDataLakeExceptionsResult;
import com.amazonaws.services.securitylake.model.ListDataLakesRequest;
import com.amazonaws.services.securitylake.model.ListDataLakesResult;
import com.amazonaws.services.securitylake.model.ListLogSourcesRequest;
import com.amazonaws.services.securitylake.model.ListLogSourcesResult;
import com.amazonaws.services.securitylake.model.ListSubscribersRequest;
import com.amazonaws.services.securitylake.model.ListSubscribersResult;
import com.amazonaws.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest;
import com.amazonaws.services.securitylake.model.RegisterDataLakeDelegatedAdministratorResult;
import com.amazonaws.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest;
import com.amazonaws.services.securitylake.model.UpdateDataLakeExceptionSubscriptionResult;
import com.amazonaws.services.securitylake.model.UpdateDataLakeRequest;
import com.amazonaws.services.securitylake.model.UpdateDataLakeResult;
import com.amazonaws.services.securitylake.model.UpdateSubscriberNotificationRequest;
import com.amazonaws.services.securitylake.model.UpdateSubscriberNotificationResult;
import com.amazonaws.services.securitylake.model.UpdateSubscriberRequest;
import com.amazonaws.services.securitylake.model.UpdateSubscriberResult;
import com.amazonaws.services.securitylake.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateAwsLogSourceRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateAwsLogSourceResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateCustomLogSourceRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateCustomLogSourceResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateDataLakeExceptionSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateDataLakeExceptionSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateDataLakeOrganizationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateDataLakeOrganizationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateDataLakeRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateDataLakeResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateSubscriberNotificationRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateSubscriberNotificationResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateSubscriberRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.CreateSubscriberResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteAwsLogSourceRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteAwsLogSourceResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteCustomLogSourceRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteCustomLogSourceResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteDataLakeExceptionSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteDataLakeExceptionSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteDataLakeOrganizationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteDataLakeOrganizationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteDataLakeRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteDataLakeResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteSubscriberNotificationRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteSubscriberNotificationResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteSubscriberRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeleteSubscriberResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.DeregisterDataLakeDelegatedAdministratorRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.DeregisterDataLakeDelegatedAdministratorResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.GetDataLakeExceptionSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.GetDataLakeExceptionSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.GetDataLakeOrganizationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.GetDataLakeOrganizationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.GetDataLakeSourcesRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.GetDataLakeSourcesResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.GetSubscriberRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.GetSubscriberResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.ListDataLakeExceptionsRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.ListDataLakeExceptionsResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.ListDataLakesRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.ListDataLakesResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.ListLogSourcesRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.ListLogSourcesResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.ListSubscribersRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.ListSubscribersResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.RegisterDataLakeDelegatedAdministratorRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.RegisterDataLakeDelegatedAdministratorResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateDataLakeExceptionSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateDataLakeExceptionSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateDataLakeRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateDataLakeResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateSubscriberNotificationRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateSubscriberNotificationResultJsonUnmarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateSubscriberRequestProtocolMarshaller;
import com.amazonaws.services.securitylake.model.transform.UpdateSubscriberResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonSecurityLakeClient
extends AmazonWebServiceClient
implements AmazonSecurityLake {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSecurityLake.class);
    private static final String DEFAULT_SIGNING_NAME = "securitylake";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonSecurityLakeException.class));

    public static AmazonSecurityLakeClientBuilder builder() {
        return AmazonSecurityLakeClientBuilder.standard();
    }

    AmazonSecurityLakeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonSecurityLakeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("securitylake.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/securitylake/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/securitylake/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAwsLogSourceResult createAwsLogSource(CreateAwsLogSourceRequest request) {
        request = (CreateAwsLogSourceRequest)this.beforeClientExecution(request);
        return this.executeCreateAwsLogSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAwsLogSourceResult executeCreateAwsLogSource(CreateAwsLogSourceRequest createAwsLogSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAwsLogSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAwsLogSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAwsLogSourceRequestProtocolMarshaller(protocolFactory).marshall((CreateAwsLogSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAwsLogSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAwsLogSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAwsLogSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAwsLogSourceResult createAwsLogSourceResult = (CreateAwsLogSourceResult)response.getAwsResponse();
            return createAwsLogSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCustomLogSourceResult createCustomLogSource(CreateCustomLogSourceRequest request) {
        request = (CreateCustomLogSourceRequest)this.beforeClientExecution(request);
        return this.executeCreateCustomLogSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCustomLogSourceResult executeCreateCustomLogSource(CreateCustomLogSourceRequest createCustomLogSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCustomLogSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCustomLogSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCustomLogSourceRequestProtocolMarshaller(protocolFactory).marshall((CreateCustomLogSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCustomLogSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCustomLogSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCustomLogSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCustomLogSourceResult createCustomLogSourceResult = (CreateCustomLogSourceResult)response.getAwsResponse();
            return createCustomLogSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataLakeResult createDataLake(CreateDataLakeRequest request) {
        request = (CreateDataLakeRequest)this.beforeClientExecution(request);
        return this.executeCreateDataLake(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataLakeResult executeCreateDataLake(CreateDataLakeRequest createDataLakeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataLakeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataLakeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataLakeRequestProtocolMarshaller(protocolFactory).marshall((CreateDataLakeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataLakeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataLake");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataLakeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataLakeResult createDataLakeResult = (CreateDataLakeResult)response.getAwsResponse();
            return createDataLakeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataLakeExceptionSubscriptionResult createDataLakeExceptionSubscription(CreateDataLakeExceptionSubscriptionRequest request) {
        request = (CreateDataLakeExceptionSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeCreateDataLakeExceptionSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataLakeExceptionSubscriptionResult executeCreateDataLakeExceptionSubscription(CreateDataLakeExceptionSubscriptionRequest createDataLakeExceptionSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataLakeExceptionSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataLakeExceptionSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataLakeExceptionSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((CreateDataLakeExceptionSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataLakeExceptionSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataLakeExceptionSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataLakeExceptionSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataLakeExceptionSubscriptionResult createDataLakeExceptionSubscriptionResult = (CreateDataLakeExceptionSubscriptionResult)response.getAwsResponse();
            return createDataLakeExceptionSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataLakeOrganizationConfigurationResult createDataLakeOrganizationConfiguration(CreateDataLakeOrganizationConfigurationRequest request) {
        request = (CreateDataLakeOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateDataLakeOrganizationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataLakeOrganizationConfigurationResult executeCreateDataLakeOrganizationConfiguration(CreateDataLakeOrganizationConfigurationRequest createDataLakeOrganizationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataLakeOrganizationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataLakeOrganizationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataLakeOrganizationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateDataLakeOrganizationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataLakeOrganizationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataLakeOrganizationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataLakeOrganizationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataLakeOrganizationConfigurationResult createDataLakeOrganizationConfigurationResult = (CreateDataLakeOrganizationConfigurationResult)response.getAwsResponse();
            return createDataLakeOrganizationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSubscriberResult createSubscriber(CreateSubscriberRequest request) {
        request = (CreateSubscriberRequest)this.beforeClientExecution(request);
        return this.executeCreateSubscriber(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSubscriberResult executeCreateSubscriber(CreateSubscriberRequest createSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSubscriberRequestProtocolMarshaller(protocolFactory).marshall((CreateSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSubscriber");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSubscriberResult createSubscriberResult = (CreateSubscriberResult)response.getAwsResponse();
            return createSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSubscriberNotificationResult createSubscriberNotification(CreateSubscriberNotificationRequest request) {
        request = (CreateSubscriberNotificationRequest)this.beforeClientExecution(request);
        return this.executeCreateSubscriberNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSubscriberNotificationResult executeCreateSubscriberNotification(CreateSubscriberNotificationRequest createSubscriberNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSubscriberNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSubscriberNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSubscriberNotificationRequestProtocolMarshaller(protocolFactory).marshall((CreateSubscriberNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSubscriberNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSubscriberNotification");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSubscriberNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSubscriberNotificationResult createSubscriberNotificationResult = (CreateSubscriberNotificationResult)response.getAwsResponse();
            return createSubscriberNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAwsLogSourceResult deleteAwsLogSource(DeleteAwsLogSourceRequest request) {
        request = (DeleteAwsLogSourceRequest)this.beforeClientExecution(request);
        return this.executeDeleteAwsLogSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAwsLogSourceResult executeDeleteAwsLogSource(DeleteAwsLogSourceRequest deleteAwsLogSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAwsLogSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAwsLogSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAwsLogSourceRequestProtocolMarshaller(protocolFactory).marshall((DeleteAwsLogSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAwsLogSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAwsLogSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAwsLogSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAwsLogSourceResult deleteAwsLogSourceResult = (DeleteAwsLogSourceResult)response.getAwsResponse();
            return deleteAwsLogSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCustomLogSourceResult deleteCustomLogSource(DeleteCustomLogSourceRequest request) {
        request = (DeleteCustomLogSourceRequest)this.beforeClientExecution(request);
        return this.executeDeleteCustomLogSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCustomLogSourceResult executeDeleteCustomLogSource(DeleteCustomLogSourceRequest deleteCustomLogSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCustomLogSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCustomLogSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCustomLogSourceRequestProtocolMarshaller(protocolFactory).marshall((DeleteCustomLogSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCustomLogSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCustomLogSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCustomLogSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCustomLogSourceResult deleteCustomLogSourceResult = (DeleteCustomLogSourceResult)response.getAwsResponse();
            return deleteCustomLogSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataLakeResult deleteDataLake(DeleteDataLakeRequest request) {
        request = (DeleteDataLakeRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataLake(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataLakeResult executeDeleteDataLake(DeleteDataLakeRequest deleteDataLakeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataLakeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataLakeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataLakeRequestProtocolMarshaller(protocolFactory).marshall((DeleteDataLakeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDataLakeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataLake");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataLakeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataLakeResult deleteDataLakeResult = (DeleteDataLakeResult)response.getAwsResponse();
            return deleteDataLakeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataLakeExceptionSubscriptionResult deleteDataLakeExceptionSubscription(DeleteDataLakeExceptionSubscriptionRequest request) {
        request = (DeleteDataLakeExceptionSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataLakeExceptionSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataLakeExceptionSubscriptionResult executeDeleteDataLakeExceptionSubscription(DeleteDataLakeExceptionSubscriptionRequest deleteDataLakeExceptionSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataLakeExceptionSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataLakeExceptionSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataLakeExceptionSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((DeleteDataLakeExceptionSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDataLakeExceptionSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataLakeExceptionSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataLakeExceptionSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataLakeExceptionSubscriptionResult deleteDataLakeExceptionSubscriptionResult = (DeleteDataLakeExceptionSubscriptionResult)response.getAwsResponse();
            return deleteDataLakeExceptionSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataLakeOrganizationConfigurationResult deleteDataLakeOrganizationConfiguration(DeleteDataLakeOrganizationConfigurationRequest request) {
        request = (DeleteDataLakeOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataLakeOrganizationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataLakeOrganizationConfigurationResult executeDeleteDataLakeOrganizationConfiguration(DeleteDataLakeOrganizationConfigurationRequest deleteDataLakeOrganizationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataLakeOrganizationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataLakeOrganizationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataLakeOrganizationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteDataLakeOrganizationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDataLakeOrganizationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataLakeOrganizationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataLakeOrganizationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataLakeOrganizationConfigurationResult deleteDataLakeOrganizationConfigurationResult = (DeleteDataLakeOrganizationConfigurationResult)response.getAwsResponse();
            return deleteDataLakeOrganizationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSubscriberResult deleteSubscriber(DeleteSubscriberRequest request) {
        request = (DeleteSubscriberRequest)this.beforeClientExecution(request);
        return this.executeDeleteSubscriber(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSubscriberResult executeDeleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubscriberRequestProtocolMarshaller(protocolFactory).marshall((DeleteSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSubscriber");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubscriberResult deleteSubscriberResult = (DeleteSubscriberResult)response.getAwsResponse();
            return deleteSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSubscriberNotificationResult deleteSubscriberNotification(DeleteSubscriberNotificationRequest request) {
        request = (DeleteSubscriberNotificationRequest)this.beforeClientExecution(request);
        return this.executeDeleteSubscriberNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSubscriberNotificationResult executeDeleteSubscriberNotification(DeleteSubscriberNotificationRequest deleteSubscriberNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubscriberNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubscriberNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubscriberNotificationRequestProtocolMarshaller(protocolFactory).marshall((DeleteSubscriberNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSubscriberNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSubscriberNotification");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSubscriberNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubscriberNotificationResult deleteSubscriberNotificationResult = (DeleteSubscriberNotificationResult)response.getAwsResponse();
            return deleteSubscriberNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterDataLakeDelegatedAdministratorResult deregisterDataLakeDelegatedAdministrator(DeregisterDataLakeDelegatedAdministratorRequest request) {
        request = (DeregisterDataLakeDelegatedAdministratorRequest)this.beforeClientExecution(request);
        return this.executeDeregisterDataLakeDelegatedAdministrator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterDataLakeDelegatedAdministratorResult executeDeregisterDataLakeDelegatedAdministrator(DeregisterDataLakeDelegatedAdministratorRequest deregisterDataLakeDelegatedAdministratorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterDataLakeDelegatedAdministratorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterDataLakeDelegatedAdministratorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterDataLakeDelegatedAdministratorRequestProtocolMarshaller(protocolFactory).marshall((DeregisterDataLakeDelegatedAdministratorRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterDataLakeDelegatedAdministratorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterDataLakeDelegatedAdministrator");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterDataLakeDelegatedAdministratorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterDataLakeDelegatedAdministratorResult deregisterDataLakeDelegatedAdministratorResult = (DeregisterDataLakeDelegatedAdministratorResult)response.getAwsResponse();
            return deregisterDataLakeDelegatedAdministratorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataLakeExceptionSubscriptionResult getDataLakeExceptionSubscription(GetDataLakeExceptionSubscriptionRequest request) {
        request = (GetDataLakeExceptionSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeGetDataLakeExceptionSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataLakeExceptionSubscriptionResult executeGetDataLakeExceptionSubscription(GetDataLakeExceptionSubscriptionRequest getDataLakeExceptionSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataLakeExceptionSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataLakeExceptionSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataLakeExceptionSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((GetDataLakeExceptionSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataLakeExceptionSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataLakeExceptionSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataLakeExceptionSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataLakeExceptionSubscriptionResult getDataLakeExceptionSubscriptionResult = (GetDataLakeExceptionSubscriptionResult)response.getAwsResponse();
            return getDataLakeExceptionSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataLakeOrganizationConfigurationResult getDataLakeOrganizationConfiguration(GetDataLakeOrganizationConfigurationRequest request) {
        request = (GetDataLakeOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetDataLakeOrganizationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataLakeOrganizationConfigurationResult executeGetDataLakeOrganizationConfiguration(GetDataLakeOrganizationConfigurationRequest getDataLakeOrganizationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataLakeOrganizationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataLakeOrganizationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataLakeOrganizationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetDataLakeOrganizationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataLakeOrganizationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataLakeOrganizationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataLakeOrganizationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataLakeOrganizationConfigurationResult getDataLakeOrganizationConfigurationResult = (GetDataLakeOrganizationConfigurationResult)response.getAwsResponse();
            return getDataLakeOrganizationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataLakeSourcesResult getDataLakeSources(GetDataLakeSourcesRequest request) {
        request = (GetDataLakeSourcesRequest)this.beforeClientExecution(request);
        return this.executeGetDataLakeSources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataLakeSourcesResult executeGetDataLakeSources(GetDataLakeSourcesRequest getDataLakeSourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataLakeSourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataLakeSourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataLakeSourcesRequestProtocolMarshaller(protocolFactory).marshall((GetDataLakeSourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataLakeSourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataLakeSources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataLakeSourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataLakeSourcesResult getDataLakeSourcesResult = (GetDataLakeSourcesResult)response.getAwsResponse();
            return getDataLakeSourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSubscriberResult getSubscriber(GetSubscriberRequest request) {
        request = (GetSubscriberRequest)this.beforeClientExecution(request);
        return this.executeGetSubscriber(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSubscriberResult executeGetSubscriber(GetSubscriberRequest getSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSubscriberRequestProtocolMarshaller(protocolFactory).marshall((GetSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSubscriber");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSubscriberResult getSubscriberResult = (GetSubscriberResult)response.getAwsResponse();
            return getSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataLakeExceptionsResult listDataLakeExceptions(ListDataLakeExceptionsRequest request) {
        request = (ListDataLakeExceptionsRequest)this.beforeClientExecution(request);
        return this.executeListDataLakeExceptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataLakeExceptionsResult executeListDataLakeExceptions(ListDataLakeExceptionsRequest listDataLakeExceptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataLakeExceptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataLakeExceptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataLakeExceptionsRequestProtocolMarshaller(protocolFactory).marshall((ListDataLakeExceptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataLakeExceptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataLakeExceptions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataLakeExceptionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataLakeExceptionsResult listDataLakeExceptionsResult = (ListDataLakeExceptionsResult)response.getAwsResponse();
            return listDataLakeExceptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataLakesResult listDataLakes(ListDataLakesRequest request) {
        request = (ListDataLakesRequest)this.beforeClientExecution(request);
        return this.executeListDataLakes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataLakesResult executeListDataLakes(ListDataLakesRequest listDataLakesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataLakesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataLakesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataLakesRequestProtocolMarshaller(protocolFactory).marshall((ListDataLakesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataLakesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataLakes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataLakesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataLakesResult listDataLakesResult = (ListDataLakesResult)response.getAwsResponse();
            return listDataLakesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLogSourcesResult listLogSources(ListLogSourcesRequest request) {
        request = (ListLogSourcesRequest)this.beforeClientExecution(request);
        return this.executeListLogSources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLogSourcesResult executeListLogSources(ListLogSourcesRequest listLogSourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLogSourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLogSourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLogSourcesRequestProtocolMarshaller(protocolFactory).marshall((ListLogSourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLogSourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLogSources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLogSourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLogSourcesResult listLogSourcesResult = (ListLogSourcesResult)response.getAwsResponse();
            return listLogSourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSubscribersResult listSubscribers(ListSubscribersRequest request) {
        request = (ListSubscribersRequest)this.beforeClientExecution(request);
        return this.executeListSubscribers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSubscribersResult executeListSubscribers(ListSubscribersRequest listSubscribersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSubscribersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSubscribersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSubscribersRequestProtocolMarshaller(protocolFactory).marshall((ListSubscribersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSubscribersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSubscribers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSubscribersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSubscribersResult listSubscribersResult = (ListSubscribersResult)response.getAwsResponse();
            return listSubscribersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterDataLakeDelegatedAdministratorResult registerDataLakeDelegatedAdministrator(RegisterDataLakeDelegatedAdministratorRequest request) {
        request = (RegisterDataLakeDelegatedAdministratorRequest)this.beforeClientExecution(request);
        return this.executeRegisterDataLakeDelegatedAdministrator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterDataLakeDelegatedAdministratorResult executeRegisterDataLakeDelegatedAdministrator(RegisterDataLakeDelegatedAdministratorRequest registerDataLakeDelegatedAdministratorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerDataLakeDelegatedAdministratorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDataLakeDelegatedAdministratorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDataLakeDelegatedAdministratorRequestProtocolMarshaller(protocolFactory).marshall((RegisterDataLakeDelegatedAdministratorRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerDataLakeDelegatedAdministratorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterDataLakeDelegatedAdministrator");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterDataLakeDelegatedAdministratorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterDataLakeDelegatedAdministratorResult registerDataLakeDelegatedAdministratorResult = (RegisterDataLakeDelegatedAdministratorResult)response.getAwsResponse();
            return registerDataLakeDelegatedAdministratorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDataLakeResult updateDataLake(UpdateDataLakeRequest request) {
        request = (UpdateDataLakeRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataLake(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDataLakeResult executeUpdateDataLake(UpdateDataLakeRequest updateDataLakeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDataLakeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDataLakeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDataLakeRequestProtocolMarshaller(protocolFactory).marshall((UpdateDataLakeRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDataLakeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataLake");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataLakeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDataLakeResult updateDataLakeResult = (UpdateDataLakeResult)response.getAwsResponse();
            return updateDataLakeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDataLakeExceptionSubscriptionResult updateDataLakeExceptionSubscription(UpdateDataLakeExceptionSubscriptionRequest request) {
        request = (UpdateDataLakeExceptionSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataLakeExceptionSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDataLakeExceptionSubscriptionResult executeUpdateDataLakeExceptionSubscription(UpdateDataLakeExceptionSubscriptionRequest updateDataLakeExceptionSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDataLakeExceptionSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDataLakeExceptionSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDataLakeExceptionSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((UpdateDataLakeExceptionSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDataLakeExceptionSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataLakeExceptionSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataLakeExceptionSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDataLakeExceptionSubscriptionResult updateDataLakeExceptionSubscriptionResult = (UpdateDataLakeExceptionSubscriptionResult)response.getAwsResponse();
            return updateDataLakeExceptionSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSubscriberResult updateSubscriber(UpdateSubscriberRequest request) {
        request = (UpdateSubscriberRequest)this.beforeClientExecution(request);
        return this.executeUpdateSubscriber(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSubscriberResult executeUpdateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSubscriberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSubscriberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSubscriberRequestProtocolMarshaller(protocolFactory).marshall((UpdateSubscriberRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSubscriberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSubscriber");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSubscriberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSubscriberResult updateSubscriberResult = (UpdateSubscriberResult)response.getAwsResponse();
            return updateSubscriberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSubscriberNotificationResult updateSubscriberNotification(UpdateSubscriberNotificationRequest request) {
        request = (UpdateSubscriberNotificationRequest)this.beforeClientExecution(request);
        return this.executeUpdateSubscriberNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSubscriberNotificationResult executeUpdateSubscriberNotification(UpdateSubscriberNotificationRequest updateSubscriberNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSubscriberNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSubscriberNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSubscriberNotificationRequestProtocolMarshaller(protocolFactory).marshall((UpdateSubscriberNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSubscriberNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityLake");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSubscriberNotification");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSubscriberNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSubscriberNotificationResult updateSubscriberNotificationResult = (UpdateSubscriberNotificationResult)response.getAwsResponse();
            return updateSubscriberNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

