/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.LogsStatus;
import com.amazonaws.services.securitylake.model.OcsfEventClass;
import com.amazonaws.services.securitylake.model.transform.AccountSourcesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AccountSources
implements Serializable,
Cloneable,
StructuredPojo {
    private String account;
    private String eventClass;
    private List<LogsStatus> logsStatus;
    private String sourceType;

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }

    public AccountSources withAccount(String account) {
        this.setAccount(account);
        return this;
    }

    public void setEventClass(String eventClass) {
        this.eventClass = eventClass;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public AccountSources withEventClass(String eventClass) {
        this.setEventClass(eventClass);
        return this;
    }

    public AccountSources withEventClass(OcsfEventClass eventClass) {
        this.eventClass = eventClass.toString();
        return this;
    }

    public List<LogsStatus> getLogsStatus() {
        return this.logsStatus;
    }

    public void setLogsStatus(Collection<LogsStatus> logsStatus) {
        if (logsStatus == null) {
            this.logsStatus = null;
            return;
        }
        this.logsStatus = new ArrayList<LogsStatus>(logsStatus);
    }

    public AccountSources withLogsStatus(LogsStatus ... logsStatus) {
        if (this.logsStatus == null) {
            this.setLogsStatus(new ArrayList<LogsStatus>(logsStatus.length));
        }
        for (LogsStatus ele : logsStatus) {
            this.logsStatus.add(ele);
        }
        return this;
    }

    public AccountSources withLogsStatus(Collection<LogsStatus> logsStatus) {
        this.setLogsStatus(logsStatus);
        return this;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public AccountSources withSourceType(String sourceType) {
        this.setSourceType(sourceType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccount() != null) {
            sb.append("Account: ").append(this.getAccount()).append(",");
        }
        if (this.getEventClass() != null) {
            sb.append("EventClass: ").append(this.getEventClass()).append(",");
        }
        if (this.getLogsStatus() != null) {
            sb.append("LogsStatus: ").append(this.getLogsStatus()).append(",");
        }
        if (this.getSourceType() != null) {
            sb.append("SourceType: ").append(this.getSourceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSources)) {
            return false;
        }
        AccountSources other = (AccountSources)obj;
        if (other.getAccount() == null ^ this.getAccount() == null) {
            return false;
        }
        if (other.getAccount() != null && !other.getAccount().equals(this.getAccount())) {
            return false;
        }
        if (other.getEventClass() == null ^ this.getEventClass() == null) {
            return false;
        }
        if (other.getEventClass() != null && !other.getEventClass().equals(this.getEventClass())) {
            return false;
        }
        if (other.getLogsStatus() == null ^ this.getLogsStatus() == null) {
            return false;
        }
        if (other.getLogsStatus() != null && !other.getLogsStatus().equals(this.getLogsStatus())) {
            return false;
        }
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        return other.getSourceType() == null || other.getSourceType().equals(this.getSourceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccount() == null ? 0 : this.getAccount().hashCode());
        hashCode = 31 * hashCode + (this.getEventClass() == null ? 0 : this.getEventClass().hashCode());
        hashCode = 31 * hashCode + (this.getLogsStatus() == null ? 0 : this.getLogsStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        return hashCode;
    }

    public AccountSources clone() {
        try {
            return (AccountSources)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountSourcesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

