/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.securityhub.model.AutomationRulesConfig;
import com.amazonaws.services.securityhub.model.UnprocessedAutomationRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetAutomationRulesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AutomationRulesConfig> rules;
    private List<UnprocessedAutomationRule> unprocessedAutomationRules;

    public List<AutomationRulesConfig> getRules() {
        return this.rules;
    }

    public void setRules(Collection<AutomationRulesConfig> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<AutomationRulesConfig>(rules);
    }

    public BatchGetAutomationRulesResult withRules(AutomationRulesConfig ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<AutomationRulesConfig>(rules.length));
        }
        for (AutomationRulesConfig ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public BatchGetAutomationRulesResult withRules(Collection<AutomationRulesConfig> rules) {
        this.setRules(rules);
        return this;
    }

    public List<UnprocessedAutomationRule> getUnprocessedAutomationRules() {
        return this.unprocessedAutomationRules;
    }

    public void setUnprocessedAutomationRules(Collection<UnprocessedAutomationRule> unprocessedAutomationRules) {
        if (unprocessedAutomationRules == null) {
            this.unprocessedAutomationRules = null;
            return;
        }
        this.unprocessedAutomationRules = new ArrayList<UnprocessedAutomationRule>(unprocessedAutomationRules);
    }

    public BatchGetAutomationRulesResult withUnprocessedAutomationRules(UnprocessedAutomationRule ... unprocessedAutomationRules) {
        if (this.unprocessedAutomationRules == null) {
            this.setUnprocessedAutomationRules(new ArrayList<UnprocessedAutomationRule>(unprocessedAutomationRules.length));
        }
        for (UnprocessedAutomationRule ele : unprocessedAutomationRules) {
            this.unprocessedAutomationRules.add(ele);
        }
        return this;
    }

    public BatchGetAutomationRulesResult withUnprocessedAutomationRules(Collection<UnprocessedAutomationRule> unprocessedAutomationRules) {
        this.setUnprocessedAutomationRules(unprocessedAutomationRules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getUnprocessedAutomationRules() != null) {
            sb.append("UnprocessedAutomationRules: ").append(this.getUnprocessedAutomationRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAutomationRulesResult)) {
            return false;
        }
        BatchGetAutomationRulesResult other = (BatchGetAutomationRulesResult)obj;
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getUnprocessedAutomationRules() == null ^ this.getUnprocessedAutomationRules() == null) {
            return false;
        }
        return other.getUnprocessedAutomationRules() == null || other.getUnprocessedAutomationRules().equals(this.getUnprocessedAutomationRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedAutomationRules() == null ? 0 : this.getUnprocessedAutomationRules().hashCode());
        return hashCode;
    }

    public BatchGetAutomationRulesResult clone() {
        try {
            return (BatchGetAutomationRulesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

