/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.Cvss;
import java.util.List;

@SdkInternalApi
public class CvssMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<Double> BASESCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaseScore").build();
    private static final MarshallingInfo<String> BASEVECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaseVector").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final MarshallingInfo<List> ADJUSTMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Adjustments").build();
    private static final CvssMarshaller instance = new CvssMarshaller();

    public static CvssMarshaller getInstance() {
        return instance;
    }

    public void marshall(Cvss cvss, ProtocolMarshaller protocolMarshaller) {
        if (cvss == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cvss.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)cvss.getBaseScore(), BASESCORE_BINDING);
            protocolMarshaller.marshall((Object)cvss.getBaseVector(), BASEVECTOR_BINDING);
            protocolMarshaller.marshall((Object)cvss.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(cvss.getAdjustments(), ADJUSTMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

