/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.SecurityControlsConfiguration;
import java.util.List;

@SdkInternalApi
public class SecurityControlsConfigurationMarshaller {
    private static final MarshallingInfo<List> ENABLEDSECURITYCONTROLIDENTIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnabledSecurityControlIdentifiers").build();
    private static final MarshallingInfo<List> DISABLEDSECURITYCONTROLIDENTIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisabledSecurityControlIdentifiers").build();
    private static final MarshallingInfo<List> SECURITYCONTROLCUSTOMPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityControlCustomParameters").build();
    private static final SecurityControlsConfigurationMarshaller instance = new SecurityControlsConfigurationMarshaller();

    public static SecurityControlsConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SecurityControlsConfiguration securityControlsConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (securityControlsConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(securityControlsConfiguration.getEnabledSecurityControlIdentifiers(), ENABLEDSECURITYCONTROLIDENTIFIERS_BINDING);
            protocolMarshaller.marshall(securityControlsConfiguration.getDisabledSecurityControlIdentifiers(), DISABLEDSECURITYCONTROLIDENTIFIERS_BINDING);
            protocolMarshaller.marshall(securityControlsConfiguration.getSecurityControlCustomParameters(), SECURITYCONTROLCUSTOMPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

