/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.securityhub.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetailsMarshaller {

    private static final MarshallingInfo<Integer> DAYS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Days").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Mode").build();
    private static final MarshallingInfo<Integer> YEARS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Years").build();

    private static final AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetailsMarshaller instance = new AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetailsMarshaller();

    public static AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AwsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails awsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails,
            ProtocolMarshaller protocolMarshaller) {

        if (awsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(awsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.getDays(), DAYS_BINDING);
            protocolMarshaller.marshall(awsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.getMode(), MODE_BINDING);
            protocolMarshaller.marshall(awsS3BucketObjectLockConfigurationRuleDefaultRetentionDetails.getYears(), YEARS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
