/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A resource to assign to a container.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The type of resource to assign to a container. Valid values are <code>GPU</code> or
     * <code>InferenceAccelerator</code>.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The value for the specified resource type.
     * </p>
     * <p>
     * For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for the
     * container.
     * </p>
     * <p>
     * For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an entry
     * in <code>InferenceAccelerators</code>.
     * </p>
     */
    private String value;

    /**
     * <p>
     * The type of resource to assign to a container. Valid values are <code>GPU</code> or
     * <code>InferenceAccelerator</code>.
     * </p>
     * 
     * @param type
     *        The type of resource to assign to a container. Valid values are <code>GPU</code> or
     *        <code>InferenceAccelerator</code>.
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of resource to assign to a container. Valid values are <code>GPU</code> or
     * <code>InferenceAccelerator</code>.
     * </p>
     * 
     * @return The type of resource to assign to a container. Valid values are <code>GPU</code> or
     *         <code>InferenceAccelerator</code>.
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of resource to assign to a container. Valid values are <code>GPU</code> or
     * <code>InferenceAccelerator</code>.
     * </p>
     * 
     * @param type
     *        The type of resource to assign to a container. Valid values are <code>GPU</code> or
     *        <code>InferenceAccelerator</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The value for the specified resource type.
     * </p>
     * <p>
     * For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for the
     * container.
     * </p>
     * <p>
     * For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an entry
     * in <code>InferenceAccelerators</code>.
     * </p>
     * 
     * @param value
     *        The value for the specified resource type.</p>
     *        <p>
     *        For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for
     *        the container.
     *        </p>
     *        <p>
     *        For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an
     *        entry in <code>InferenceAccelerators</code>.
     */

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     * The value for the specified resource type.
     * </p>
     * <p>
     * For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for the
     * container.
     * </p>
     * <p>
     * For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an entry
     * in <code>InferenceAccelerators</code>.
     * </p>
     * 
     * @return The value for the specified resource type.</p>
     *         <p>
     *         For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves
     *         for the container.
     *         </p>
     *         <p>
     *         For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an
     *         entry in <code>InferenceAccelerators</code>.
     */

    public String getValue() {
        return this.value;
    }

    /**
     * <p>
     * The value for the specified resource type.
     * </p>
     * <p>
     * For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for the
     * container.
     * </p>
     * <p>
     * For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an entry
     * in <code>InferenceAccelerators</code>.
     * </p>
     * 
     * @param value
     *        The value for the specified resource type.</p>
     *        <p>
     *        For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for
     *        the container.
     *        </p>
     *        <p>
     *        For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an
     *        entry in <code>InferenceAccelerators</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails withValue(String value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails == false)
            return false;
        AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) obj;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails clone() {
        try {
            return (AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetailsMarshaller.getInstance()
                .marshall(this, protocolMarshaller);
    }
}
