/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.ClassificationStatus;
import com.amazonaws.services.securityhub.model.CustomDataIdentifiersResult;
import com.amazonaws.services.securityhub.model.SensitiveDataResult;
import com.amazonaws.services.securityhub.model.transform.ClassificationResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassificationResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String mimeType;
    private Long sizeClassified;
    private Boolean additionalOccurrences;
    private ClassificationStatus status;
    private List<SensitiveDataResult> sensitiveData;
    private CustomDataIdentifiersResult customDataIdentifiers;

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public ClassificationResult withMimeType(String mimeType) {
        this.setMimeType(mimeType);
        return this;
    }

    public void setSizeClassified(Long sizeClassified) {
        this.sizeClassified = sizeClassified;
    }

    public Long getSizeClassified() {
        return this.sizeClassified;
    }

    public ClassificationResult withSizeClassified(Long sizeClassified) {
        this.setSizeClassified(sizeClassified);
        return this;
    }

    public void setAdditionalOccurrences(Boolean additionalOccurrences) {
        this.additionalOccurrences = additionalOccurrences;
    }

    public Boolean getAdditionalOccurrences() {
        return this.additionalOccurrences;
    }

    public ClassificationResult withAdditionalOccurrences(Boolean additionalOccurrences) {
        this.setAdditionalOccurrences(additionalOccurrences);
        return this;
    }

    public Boolean isAdditionalOccurrences() {
        return this.additionalOccurrences;
    }

    public void setStatus(ClassificationStatus status) {
        this.status = status;
    }

    public ClassificationStatus getStatus() {
        return this.status;
    }

    public ClassificationResult withStatus(ClassificationStatus status) {
        this.setStatus(status);
        return this;
    }

    public List<SensitiveDataResult> getSensitiveData() {
        return this.sensitiveData;
    }

    public void setSensitiveData(Collection<SensitiveDataResult> sensitiveData) {
        if (sensitiveData == null) {
            this.sensitiveData = null;
            return;
        }
        this.sensitiveData = new ArrayList<SensitiveDataResult>(sensitiveData);
    }

    public ClassificationResult withSensitiveData(SensitiveDataResult ... sensitiveData) {
        if (this.sensitiveData == null) {
            this.setSensitiveData(new ArrayList<SensitiveDataResult>(sensitiveData.length));
        }
        for (SensitiveDataResult ele : sensitiveData) {
            this.sensitiveData.add(ele);
        }
        return this;
    }

    public ClassificationResult withSensitiveData(Collection<SensitiveDataResult> sensitiveData) {
        this.setSensitiveData(sensitiveData);
        return this;
    }

    public void setCustomDataIdentifiers(CustomDataIdentifiersResult customDataIdentifiers) {
        this.customDataIdentifiers = customDataIdentifiers;
    }

    public CustomDataIdentifiersResult getCustomDataIdentifiers() {
        return this.customDataIdentifiers;
    }

    public ClassificationResult withCustomDataIdentifiers(CustomDataIdentifiersResult customDataIdentifiers) {
        this.setCustomDataIdentifiers(customDataIdentifiers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMimeType() != null) {
            sb.append("MimeType: ").append(this.getMimeType()).append(",");
        }
        if (this.getSizeClassified() != null) {
            sb.append("SizeClassified: ").append(this.getSizeClassified()).append(",");
        }
        if (this.getAdditionalOccurrences() != null) {
            sb.append("AdditionalOccurrences: ").append(this.getAdditionalOccurrences()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getSensitiveData() != null) {
            sb.append("SensitiveData: ").append(this.getSensitiveData()).append(",");
        }
        if (this.getCustomDataIdentifiers() != null) {
            sb.append("CustomDataIdentifiers: ").append(this.getCustomDataIdentifiers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationResult)) {
            return false;
        }
        ClassificationResult other = (ClassificationResult)obj;
        if (other.getMimeType() == null ^ this.getMimeType() == null) {
            return false;
        }
        if (other.getMimeType() != null && !other.getMimeType().equals(this.getMimeType())) {
            return false;
        }
        if (other.getSizeClassified() == null ^ this.getSizeClassified() == null) {
            return false;
        }
        if (other.getSizeClassified() != null && !other.getSizeClassified().equals(this.getSizeClassified())) {
            return false;
        }
        if (other.getAdditionalOccurrences() == null ^ this.getAdditionalOccurrences() == null) {
            return false;
        }
        if (other.getAdditionalOccurrences() != null && !other.getAdditionalOccurrences().equals(this.getAdditionalOccurrences())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSensitiveData() == null ^ this.getSensitiveData() == null) {
            return false;
        }
        if (other.getSensitiveData() != null && !other.getSensitiveData().equals(this.getSensitiveData())) {
            return false;
        }
        if (other.getCustomDataIdentifiers() == null ^ this.getCustomDataIdentifiers() == null) {
            return false;
        }
        return other.getCustomDataIdentifiers() == null || other.getCustomDataIdentifiers().equals(this.getCustomDataIdentifiers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMimeType() == null ? 0 : this.getMimeType().hashCode());
        hashCode = 31 * hashCode + (this.getSizeClassified() == null ? 0 : this.getSizeClassified().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOccurrences() == null ? 0 : this.getAdditionalOccurrences().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSensitiveData() == null ? 0 : this.getSensitiveData().hashCode());
        hashCode = 31 * hashCode + (this.getCustomDataIdentifiers() == null ? 0 : this.getCustomDataIdentifiers().hashCode());
        return hashCode;
    }

    public ClassificationResult clone() {
        try {
            return (ClassificationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClassificationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

