/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.ComplianceStatus;
import com.amazonaws.services.securityhub.model.StatusReason;
import com.amazonaws.services.securityhub.model.transform.ComplianceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Compliance
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private List<String> relatedRequirements;
    private List<StatusReason> statusReasons;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Compliance withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Compliance withStatus(ComplianceStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<String> getRelatedRequirements() {
        return this.relatedRequirements;
    }

    public void setRelatedRequirements(Collection<String> relatedRequirements) {
        if (relatedRequirements == null) {
            this.relatedRequirements = null;
            return;
        }
        this.relatedRequirements = new ArrayList<String>(relatedRequirements);
    }

    public Compliance withRelatedRequirements(String ... relatedRequirements) {
        if (this.relatedRequirements == null) {
            this.setRelatedRequirements(new ArrayList<String>(relatedRequirements.length));
        }
        for (String ele : relatedRequirements) {
            this.relatedRequirements.add(ele);
        }
        return this;
    }

    public Compliance withRelatedRequirements(Collection<String> relatedRequirements) {
        this.setRelatedRequirements(relatedRequirements);
        return this;
    }

    public List<StatusReason> getStatusReasons() {
        return this.statusReasons;
    }

    public void setStatusReasons(Collection<StatusReason> statusReasons) {
        if (statusReasons == null) {
            this.statusReasons = null;
            return;
        }
        this.statusReasons = new ArrayList<StatusReason>(statusReasons);
    }

    public Compliance withStatusReasons(StatusReason ... statusReasons) {
        if (this.statusReasons == null) {
            this.setStatusReasons(new ArrayList<StatusReason>(statusReasons.length));
        }
        for (StatusReason ele : statusReasons) {
            this.statusReasons.add(ele);
        }
        return this;
    }

    public Compliance withStatusReasons(Collection<StatusReason> statusReasons) {
        this.setStatusReasons(statusReasons);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getRelatedRequirements() != null) {
            sb.append("RelatedRequirements: ").append(this.getRelatedRequirements()).append(",");
        }
        if (this.getStatusReasons() != null) {
            sb.append("StatusReasons: ").append(this.getStatusReasons());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRelatedRequirements() == null ^ this.getRelatedRequirements() == null) {
            return false;
        }
        if (other.getRelatedRequirements() != null && !other.getRelatedRequirements().equals(this.getRelatedRequirements())) {
            return false;
        }
        if (other.getStatusReasons() == null ^ this.getStatusReasons() == null) {
            return false;
        }
        return other.getStatusReasons() == null || other.getStatusReasons().equals(this.getStatusReasons());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedRequirements() == null ? 0 : this.getRelatedRequirements().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReasons() == null ? 0 : this.getStatusReasons().hashCode());
        return hashCode;
    }

    public Compliance clone() {
        try {
            return (Compliance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

