/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.securityhub.AWSSecurityHub;
import com.amazonaws.services.securityhub.AWSSecurityHubClientBuilder;
import com.amazonaws.services.securityhub.model.AWSSecurityHubException;
import com.amazonaws.services.securityhub.model.AcceptInvitationRequest;
import com.amazonaws.services.securityhub.model.AcceptInvitationResult;
import com.amazonaws.services.securityhub.model.BatchDisableStandardsRequest;
import com.amazonaws.services.securityhub.model.BatchDisableStandardsResult;
import com.amazonaws.services.securityhub.model.BatchEnableStandardsRequest;
import com.amazonaws.services.securityhub.model.BatchEnableStandardsResult;
import com.amazonaws.services.securityhub.model.BatchImportFindingsRequest;
import com.amazonaws.services.securityhub.model.BatchImportFindingsResult;
import com.amazonaws.services.securityhub.model.CreateActionTargetRequest;
import com.amazonaws.services.securityhub.model.CreateActionTargetResult;
import com.amazonaws.services.securityhub.model.CreateInsightRequest;
import com.amazonaws.services.securityhub.model.CreateInsightResult;
import com.amazonaws.services.securityhub.model.CreateMembersRequest;
import com.amazonaws.services.securityhub.model.CreateMembersResult;
import com.amazonaws.services.securityhub.model.DeclineInvitationsRequest;
import com.amazonaws.services.securityhub.model.DeclineInvitationsResult;
import com.amazonaws.services.securityhub.model.DeleteActionTargetRequest;
import com.amazonaws.services.securityhub.model.DeleteActionTargetResult;
import com.amazonaws.services.securityhub.model.DeleteInsightRequest;
import com.amazonaws.services.securityhub.model.DeleteInsightResult;
import com.amazonaws.services.securityhub.model.DeleteInvitationsRequest;
import com.amazonaws.services.securityhub.model.DeleteInvitationsResult;
import com.amazonaws.services.securityhub.model.DeleteMembersRequest;
import com.amazonaws.services.securityhub.model.DeleteMembersResult;
import com.amazonaws.services.securityhub.model.DescribeActionTargetsRequest;
import com.amazonaws.services.securityhub.model.DescribeActionTargetsResult;
import com.amazonaws.services.securityhub.model.DescribeHubRequest;
import com.amazonaws.services.securityhub.model.DescribeHubResult;
import com.amazonaws.services.securityhub.model.DescribeProductsRequest;
import com.amazonaws.services.securityhub.model.DescribeProductsResult;
import com.amazonaws.services.securityhub.model.DisableImportFindingsForProductRequest;
import com.amazonaws.services.securityhub.model.DisableImportFindingsForProductResult;
import com.amazonaws.services.securityhub.model.DisableSecurityHubRequest;
import com.amazonaws.services.securityhub.model.DisableSecurityHubResult;
import com.amazonaws.services.securityhub.model.DisassociateFromMasterAccountRequest;
import com.amazonaws.services.securityhub.model.DisassociateFromMasterAccountResult;
import com.amazonaws.services.securityhub.model.DisassociateMembersRequest;
import com.amazonaws.services.securityhub.model.DisassociateMembersResult;
import com.amazonaws.services.securityhub.model.EnableImportFindingsForProductRequest;
import com.amazonaws.services.securityhub.model.EnableImportFindingsForProductResult;
import com.amazonaws.services.securityhub.model.EnableSecurityHubRequest;
import com.amazonaws.services.securityhub.model.EnableSecurityHubResult;
import com.amazonaws.services.securityhub.model.GetEnabledStandardsRequest;
import com.amazonaws.services.securityhub.model.GetEnabledStandardsResult;
import com.amazonaws.services.securityhub.model.GetFindingsRequest;
import com.amazonaws.services.securityhub.model.GetFindingsResult;
import com.amazonaws.services.securityhub.model.GetInsightResultsRequest;
import com.amazonaws.services.securityhub.model.GetInsightResultsResult;
import com.amazonaws.services.securityhub.model.GetInsightsRequest;
import com.amazonaws.services.securityhub.model.GetInsightsResult;
import com.amazonaws.services.securityhub.model.GetInvitationsCountRequest;
import com.amazonaws.services.securityhub.model.GetInvitationsCountResult;
import com.amazonaws.services.securityhub.model.GetMasterAccountRequest;
import com.amazonaws.services.securityhub.model.GetMasterAccountResult;
import com.amazonaws.services.securityhub.model.GetMembersRequest;
import com.amazonaws.services.securityhub.model.GetMembersResult;
import com.amazonaws.services.securityhub.model.InviteMembersRequest;
import com.amazonaws.services.securityhub.model.InviteMembersResult;
import com.amazonaws.services.securityhub.model.ListEnabledProductsForImportRequest;
import com.amazonaws.services.securityhub.model.ListEnabledProductsForImportResult;
import com.amazonaws.services.securityhub.model.ListInvitationsRequest;
import com.amazonaws.services.securityhub.model.ListInvitationsResult;
import com.amazonaws.services.securityhub.model.ListMembersRequest;
import com.amazonaws.services.securityhub.model.ListMembersResult;
import com.amazonaws.services.securityhub.model.ListTagsForResourceRequest;
import com.amazonaws.services.securityhub.model.ListTagsForResourceResult;
import com.amazonaws.services.securityhub.model.TagResourceRequest;
import com.amazonaws.services.securityhub.model.TagResourceResult;
import com.amazonaws.services.securityhub.model.UntagResourceRequest;
import com.amazonaws.services.securityhub.model.UntagResourceResult;
import com.amazonaws.services.securityhub.model.UpdateActionTargetRequest;
import com.amazonaws.services.securityhub.model.UpdateActionTargetResult;
import com.amazonaws.services.securityhub.model.UpdateFindingsRequest;
import com.amazonaws.services.securityhub.model.UpdateFindingsResult;
import com.amazonaws.services.securityhub.model.UpdateInsightRequest;
import com.amazonaws.services.securityhub.model.UpdateInsightResult;
import com.amazonaws.services.securityhub.model.transform.AcceptInvitationRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.AcceptInvitationResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.BatchDisableStandardsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.BatchDisableStandardsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.BatchEnableStandardsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.BatchEnableStandardsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.BatchImportFindingsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.BatchImportFindingsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.CreateActionTargetRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.CreateActionTargetResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.CreateInsightRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.CreateInsightResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.CreateMembersRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.CreateMembersResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DeclineInvitationsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DeclineInvitationsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteActionTargetRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteActionTargetResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteInsightRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteInsightResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteInvitationsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteInvitationsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteMembersRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DeleteMembersResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DescribeActionTargetsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DescribeActionTargetsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DescribeHubRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DescribeHubResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DescribeProductsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DescribeProductsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DisableImportFindingsForProductRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DisableImportFindingsForProductResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DisableSecurityHubRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DisableSecurityHubResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DisassociateFromMasterAccountRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DisassociateFromMasterAccountResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.DisassociateMembersRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.DisassociateMembersResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.EnableImportFindingsForProductRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.EnableImportFindingsForProductResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.EnableSecurityHubRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.EnableSecurityHubResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.GetEnabledStandardsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.GetEnabledStandardsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.GetFindingsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.GetFindingsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.GetInsightResultsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.GetInsightResultsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.GetInsightsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.GetInsightsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.GetInvitationsCountRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.GetInvitationsCountResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.GetMasterAccountRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.GetMasterAccountResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.GetMembersRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.GetMembersResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.InvalidAccessExceptionUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.InviteMembersRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.InviteMembersResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.ListEnabledProductsForImportRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.ListEnabledProductsForImportResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.ListInvitationsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.ListInvitationsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.ListMembersRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.ListMembersResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.ResourceConflictExceptionUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.UpdateActionTargetRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.UpdateActionTargetResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.UpdateFindingsRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.UpdateFindingsResultJsonUnmarshaller;
import com.amazonaws.services.securityhub.model.transform.UpdateInsightRequestProtocolMarshaller;
import com.amazonaws.services.securityhub.model.transform.UpdateInsightResultJsonUnmarshaller;
import com.amazonaws.transform.JsonBaseExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSecurityHubClient
extends AmazonWebServiceClient
implements AWSSecurityHub {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSecurityHub.class);
    private static final String DEFAULT_SIGNING_NAME = "securityhub";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidAccessException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidAccessExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidInputExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode(null).withExceptionUnmarshaller((JsonErrorUnmarshaller)new JsonBaseExceptionUnmarshaller(AWSSecurityHubException.class))));

    public static AWSSecurityHubClientBuilder builder() {
        return AWSSecurityHubClientBuilder.standard();
    }

    AWSSecurityHubClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSecurityHubClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("securityhub.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/securityhub/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/securityhub/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AcceptInvitationResult acceptInvitation(AcceptInvitationRequest request) {
        request = (AcceptInvitationRequest)this.beforeClientExecution(request);
        return this.executeAcceptInvitation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcceptInvitationResult executeAcceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acceptInvitationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcceptInvitationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcceptInvitationRequestProtocolMarshaller(protocolFactory).marshall((AcceptInvitationRequest)super.beforeMarshalling((AmazonWebServiceRequest)acceptInvitationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AcceptInvitation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptInvitationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcceptInvitationResult acceptInvitationResult = (AcceptInvitationResult)response.getAwsResponse();
            return acceptInvitationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDisableStandardsResult batchDisableStandards(BatchDisableStandardsRequest request) {
        request = (BatchDisableStandardsRequest)this.beforeClientExecution(request);
        return this.executeBatchDisableStandards(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDisableStandardsResult executeBatchDisableStandards(BatchDisableStandardsRequest batchDisableStandardsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDisableStandardsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDisableStandardsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDisableStandardsRequestProtocolMarshaller(protocolFactory).marshall((BatchDisableStandardsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDisableStandardsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDisableStandards");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDisableStandardsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDisableStandardsResult batchDisableStandardsResult = (BatchDisableStandardsResult)response.getAwsResponse();
            return batchDisableStandardsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchEnableStandardsResult batchEnableStandards(BatchEnableStandardsRequest request) {
        request = (BatchEnableStandardsRequest)this.beforeClientExecution(request);
        return this.executeBatchEnableStandards(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchEnableStandardsResult executeBatchEnableStandards(BatchEnableStandardsRequest batchEnableStandardsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchEnableStandardsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchEnableStandardsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchEnableStandardsRequestProtocolMarshaller(protocolFactory).marshall((BatchEnableStandardsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchEnableStandardsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchEnableStandards");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchEnableStandardsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchEnableStandardsResult batchEnableStandardsResult = (BatchEnableStandardsResult)response.getAwsResponse();
            return batchEnableStandardsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchImportFindingsResult batchImportFindings(BatchImportFindingsRequest request) {
        request = (BatchImportFindingsRequest)this.beforeClientExecution(request);
        return this.executeBatchImportFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchImportFindingsResult executeBatchImportFindings(BatchImportFindingsRequest batchImportFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchImportFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchImportFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchImportFindingsRequestProtocolMarshaller(protocolFactory).marshall((BatchImportFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchImportFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchImportFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchImportFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchImportFindingsResult batchImportFindingsResult = (BatchImportFindingsResult)response.getAwsResponse();
            return batchImportFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateActionTargetResult createActionTarget(CreateActionTargetRequest request) {
        request = (CreateActionTargetRequest)this.beforeClientExecution(request);
        return this.executeCreateActionTarget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateActionTargetResult executeCreateActionTarget(CreateActionTargetRequest createActionTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createActionTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateActionTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateActionTargetRequestProtocolMarshaller(protocolFactory).marshall((CreateActionTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createActionTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateActionTarget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateActionTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateActionTargetResult createActionTargetResult = (CreateActionTargetResult)response.getAwsResponse();
            return createActionTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInsightResult createInsight(CreateInsightRequest request) {
        request = (CreateInsightRequest)this.beforeClientExecution(request);
        return this.executeCreateInsight(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInsightResult executeCreateInsight(CreateInsightRequest createInsightRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInsightRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInsightRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInsightRequestProtocolMarshaller(protocolFactory).marshall((CreateInsightRequest)super.beforeMarshalling((AmazonWebServiceRequest)createInsightRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateInsight");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInsightResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInsightResult createInsightResult = (CreateInsightResult)response.getAwsResponse();
            return createInsightResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMembersResult createMembers(CreateMembersRequest request) {
        request = (CreateMembersRequest)this.beforeClientExecution(request);
        return this.executeCreateMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMembersResult executeCreateMembers(CreateMembersRequest createMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMembersRequestProtocolMarshaller(protocolFactory).marshall((CreateMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMembersResult createMembersResult = (CreateMembersResult)response.getAwsResponse();
            return createMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeclineInvitationsResult declineInvitations(DeclineInvitationsRequest request) {
        request = (DeclineInvitationsRequest)this.beforeClientExecution(request);
        return this.executeDeclineInvitations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeclineInvitationsResult executeDeclineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(declineInvitationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeclineInvitationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeclineInvitationsRequestProtocolMarshaller(protocolFactory).marshall((DeclineInvitationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)declineInvitationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeclineInvitations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeclineInvitationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeclineInvitationsResult declineInvitationsResult = (DeclineInvitationsResult)response.getAwsResponse();
            return declineInvitationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteActionTargetResult deleteActionTarget(DeleteActionTargetRequest request) {
        request = (DeleteActionTargetRequest)this.beforeClientExecution(request);
        return this.executeDeleteActionTarget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteActionTargetResult executeDeleteActionTarget(DeleteActionTargetRequest deleteActionTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteActionTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteActionTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteActionTargetRequestProtocolMarshaller(protocolFactory).marshall((DeleteActionTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteActionTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteActionTarget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteActionTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteActionTargetResult deleteActionTargetResult = (DeleteActionTargetResult)response.getAwsResponse();
            return deleteActionTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInsightResult deleteInsight(DeleteInsightRequest request) {
        request = (DeleteInsightRequest)this.beforeClientExecution(request);
        return this.executeDeleteInsight(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInsightResult executeDeleteInsight(DeleteInsightRequest deleteInsightRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInsightRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInsightRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInsightRequestProtocolMarshaller(protocolFactory).marshall((DeleteInsightRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteInsightRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteInsight");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInsightResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInsightResult deleteInsightResult = (DeleteInsightResult)response.getAwsResponse();
            return deleteInsightResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInvitationsResult deleteInvitations(DeleteInvitationsRequest request) {
        request = (DeleteInvitationsRequest)this.beforeClientExecution(request);
        return this.executeDeleteInvitations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInvitationsResult executeDeleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInvitationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInvitationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInvitationsRequestProtocolMarshaller(protocolFactory).marshall((DeleteInvitationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteInvitationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteInvitations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInvitationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInvitationsResult deleteInvitationsResult = (DeleteInvitationsResult)response.getAwsResponse();
            return deleteInvitationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMembersResult deleteMembers(DeleteMembersRequest request) {
        request = (DeleteMembersRequest)this.beforeClientExecution(request);
        return this.executeDeleteMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMembersResult executeDeleteMembers(DeleteMembersRequest deleteMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMembersRequestProtocolMarshaller(protocolFactory).marshall((DeleteMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMembersResult deleteMembersResult = (DeleteMembersResult)response.getAwsResponse();
            return deleteMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeActionTargetsResult describeActionTargets(DescribeActionTargetsRequest request) {
        request = (DescribeActionTargetsRequest)this.beforeClientExecution(request);
        return this.executeDescribeActionTargets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeActionTargetsResult executeDescribeActionTargets(DescribeActionTargetsRequest describeActionTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeActionTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeActionTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeActionTargetsRequestProtocolMarshaller(protocolFactory).marshall((DescribeActionTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeActionTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeActionTargets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeActionTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeActionTargetsResult describeActionTargetsResult = (DescribeActionTargetsResult)response.getAwsResponse();
            return describeActionTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHubResult describeHub(DescribeHubRequest request) {
        request = (DescribeHubRequest)this.beforeClientExecution(request);
        return this.executeDescribeHub(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeHubResult executeDescribeHub(DescribeHubRequest describeHubRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHubRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHubRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHubRequestProtocolMarshaller(protocolFactory).marshall((DescribeHubRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHubRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeHub");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHubResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeHubResult describeHubResult = (DescribeHubResult)response.getAwsResponse();
            return describeHubResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProductsResult describeProducts(DescribeProductsRequest request) {
        request = (DescribeProductsRequest)this.beforeClientExecution(request);
        return this.executeDescribeProducts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProductsResult executeDescribeProducts(DescribeProductsRequest describeProductsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProductsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProductsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProductsRequestProtocolMarshaller(protocolFactory).marshall((DescribeProductsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProductsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProducts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProductsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProductsResult describeProductsResult = (DescribeProductsResult)response.getAwsResponse();
            return describeProductsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableImportFindingsForProductResult disableImportFindingsForProduct(DisableImportFindingsForProductRequest request) {
        request = (DisableImportFindingsForProductRequest)this.beforeClientExecution(request);
        return this.executeDisableImportFindingsForProduct(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableImportFindingsForProductResult executeDisableImportFindingsForProduct(DisableImportFindingsForProductRequest disableImportFindingsForProductRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableImportFindingsForProductRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableImportFindingsForProductRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableImportFindingsForProductRequestProtocolMarshaller(protocolFactory).marshall((DisableImportFindingsForProductRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableImportFindingsForProductRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisableImportFindingsForProduct");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableImportFindingsForProductResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableImportFindingsForProductResult disableImportFindingsForProductResult = (DisableImportFindingsForProductResult)response.getAwsResponse();
            return disableImportFindingsForProductResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableSecurityHubResult disableSecurityHub(DisableSecurityHubRequest request) {
        request = (DisableSecurityHubRequest)this.beforeClientExecution(request);
        return this.executeDisableSecurityHub(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableSecurityHubResult executeDisableSecurityHub(DisableSecurityHubRequest disableSecurityHubRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableSecurityHubRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableSecurityHubRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableSecurityHubRequestProtocolMarshaller(protocolFactory).marshall((DisableSecurityHubRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableSecurityHubRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisableSecurityHub");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableSecurityHubResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableSecurityHubResult disableSecurityHubResult = (DisableSecurityHubResult)response.getAwsResponse();
            return disableSecurityHubResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateFromMasterAccountResult disassociateFromMasterAccount(DisassociateFromMasterAccountRequest request) {
        request = (DisassociateFromMasterAccountRequest)this.beforeClientExecution(request);
        return this.executeDisassociateFromMasterAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateFromMasterAccountResult executeDisassociateFromMasterAccount(DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateFromMasterAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateFromMasterAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateFromMasterAccountRequestProtocolMarshaller(protocolFactory).marshall((DisassociateFromMasterAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateFromMasterAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateFromMasterAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateFromMasterAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateFromMasterAccountResult disassociateFromMasterAccountResult = (DisassociateFromMasterAccountResult)response.getAwsResponse();
            return disassociateFromMasterAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateMembersResult disassociateMembers(DisassociateMembersRequest request) {
        request = (DisassociateMembersRequest)this.beforeClientExecution(request);
        return this.executeDisassociateMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateMembersResult executeDisassociateMembers(DisassociateMembersRequest disassociateMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateMembersRequestProtocolMarshaller(protocolFactory).marshall((DisassociateMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateMembersResult disassociateMembersResult = (DisassociateMembersResult)response.getAwsResponse();
            return disassociateMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableImportFindingsForProductResult enableImportFindingsForProduct(EnableImportFindingsForProductRequest request) {
        request = (EnableImportFindingsForProductRequest)this.beforeClientExecution(request);
        return this.executeEnableImportFindingsForProduct(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableImportFindingsForProductResult executeEnableImportFindingsForProduct(EnableImportFindingsForProductRequest enableImportFindingsForProductRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableImportFindingsForProductRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableImportFindingsForProductRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableImportFindingsForProductRequestProtocolMarshaller(protocolFactory).marshall((EnableImportFindingsForProductRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableImportFindingsForProductRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableImportFindingsForProduct");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableImportFindingsForProductResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableImportFindingsForProductResult enableImportFindingsForProductResult = (EnableImportFindingsForProductResult)response.getAwsResponse();
            return enableImportFindingsForProductResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableSecurityHubResult enableSecurityHub(EnableSecurityHubRequest request) {
        request = (EnableSecurityHubRequest)this.beforeClientExecution(request);
        return this.executeEnableSecurityHub(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableSecurityHubResult executeEnableSecurityHub(EnableSecurityHubRequest enableSecurityHubRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableSecurityHubRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableSecurityHubRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableSecurityHubRequestProtocolMarshaller(protocolFactory).marshall((EnableSecurityHubRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableSecurityHubRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableSecurityHub");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableSecurityHubResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableSecurityHubResult enableSecurityHubResult = (EnableSecurityHubResult)response.getAwsResponse();
            return enableSecurityHubResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEnabledStandardsResult getEnabledStandards(GetEnabledStandardsRequest request) {
        request = (GetEnabledStandardsRequest)this.beforeClientExecution(request);
        return this.executeGetEnabledStandards(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEnabledStandardsResult executeGetEnabledStandards(GetEnabledStandardsRequest getEnabledStandardsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEnabledStandardsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEnabledStandardsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEnabledStandardsRequestProtocolMarshaller(protocolFactory).marshall((GetEnabledStandardsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEnabledStandardsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEnabledStandards");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEnabledStandardsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEnabledStandardsResult getEnabledStandardsResult = (GetEnabledStandardsResult)response.getAwsResponse();
            return getEnabledStandardsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFindingsResult getFindings(GetFindingsRequest request) {
        request = (GetFindingsRequest)this.beforeClientExecution(request);
        return this.executeGetFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFindingsResult executeGetFindings(GetFindingsRequest getFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFindingsRequestProtocolMarshaller(protocolFactory).marshall((GetFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFindingsResult getFindingsResult = (GetFindingsResult)response.getAwsResponse();
            return getFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInsightResultsResult getInsightResults(GetInsightResultsRequest request) {
        request = (GetInsightResultsRequest)this.beforeClientExecution(request);
        return this.executeGetInsightResults(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInsightResultsResult executeGetInsightResults(GetInsightResultsRequest getInsightResultsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInsightResultsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInsightResultsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInsightResultsRequestProtocolMarshaller(protocolFactory).marshall((GetInsightResultsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInsightResultsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInsightResults");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInsightResultsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInsightResultsResult getInsightResultsResult = (GetInsightResultsResult)response.getAwsResponse();
            return getInsightResultsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInsightsResult getInsights(GetInsightsRequest request) {
        request = (GetInsightsRequest)this.beforeClientExecution(request);
        return this.executeGetInsights(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInsightsResult executeGetInsights(GetInsightsRequest getInsightsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInsightsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInsightsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInsightsRequestProtocolMarshaller(protocolFactory).marshall((GetInsightsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInsightsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInsights");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInsightsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInsightsResult getInsightsResult = (GetInsightsResult)response.getAwsResponse();
            return getInsightsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInvitationsCountResult getInvitationsCount(GetInvitationsCountRequest request) {
        request = (GetInvitationsCountRequest)this.beforeClientExecution(request);
        return this.executeGetInvitationsCount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInvitationsCountResult executeGetInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInvitationsCountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInvitationsCountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInvitationsCountRequestProtocolMarshaller(protocolFactory).marshall((GetInvitationsCountRequest)super.beforeMarshalling((AmazonWebServiceRequest)getInvitationsCountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetInvitationsCount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetInvitationsCountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInvitationsCountResult getInvitationsCountResult = (GetInvitationsCountResult)response.getAwsResponse();
            return getInvitationsCountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMasterAccountResult getMasterAccount(GetMasterAccountRequest request) {
        request = (GetMasterAccountRequest)this.beforeClientExecution(request);
        return this.executeGetMasterAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMasterAccountResult executeGetMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMasterAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMasterAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMasterAccountRequestProtocolMarshaller(protocolFactory).marshall((GetMasterAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMasterAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMasterAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMasterAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMasterAccountResult getMasterAccountResult = (GetMasterAccountResult)response.getAwsResponse();
            return getMasterAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMembersResult getMembers(GetMembersRequest request) {
        request = (GetMembersRequest)this.beforeClientExecution(request);
        return this.executeGetMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMembersResult executeGetMembers(GetMembersRequest getMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMembersRequestProtocolMarshaller(protocolFactory).marshall((GetMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMembersResult getMembersResult = (GetMembersResult)response.getAwsResponse();
            return getMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InviteMembersResult inviteMembers(InviteMembersRequest request) {
        request = (InviteMembersRequest)this.beforeClientExecution(request);
        return this.executeInviteMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InviteMembersResult executeInviteMembers(InviteMembersRequest inviteMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(inviteMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InviteMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InviteMembersRequestProtocolMarshaller(protocolFactory).marshall((InviteMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)inviteMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InviteMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InviteMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InviteMembersResult inviteMembersResult = (InviteMembersResult)response.getAwsResponse();
            return inviteMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEnabledProductsForImportResult listEnabledProductsForImport(ListEnabledProductsForImportRequest request) {
        request = (ListEnabledProductsForImportRequest)this.beforeClientExecution(request);
        return this.executeListEnabledProductsForImport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEnabledProductsForImportResult executeListEnabledProductsForImport(ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEnabledProductsForImportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEnabledProductsForImportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEnabledProductsForImportRequestProtocolMarshaller(protocolFactory).marshall((ListEnabledProductsForImportRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEnabledProductsForImportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEnabledProductsForImport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEnabledProductsForImportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEnabledProductsForImportResult listEnabledProductsForImportResult = (ListEnabledProductsForImportResult)response.getAwsResponse();
            return listEnabledProductsForImportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInvitationsResult listInvitations(ListInvitationsRequest request) {
        request = (ListInvitationsRequest)this.beforeClientExecution(request);
        return this.executeListInvitations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInvitationsResult executeListInvitations(ListInvitationsRequest listInvitationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInvitationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInvitationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInvitationsRequestProtocolMarshaller(protocolFactory).marshall((ListInvitationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInvitationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInvitations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInvitationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInvitationsResult listInvitationsResult = (ListInvitationsResult)response.getAwsResponse();
            return listInvitationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        request = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executeListMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMembersResult executeListMembers(ListMembersRequest listMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMembersRequestProtocolMarshaller(protocolFactory).marshall((ListMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMembersResult listMembersResult = (ListMembersResult)response.getAwsResponse();
            return listMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateActionTargetResult updateActionTarget(UpdateActionTargetRequest request) {
        request = (UpdateActionTargetRequest)this.beforeClientExecution(request);
        return this.executeUpdateActionTarget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateActionTargetResult executeUpdateActionTarget(UpdateActionTargetRequest updateActionTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateActionTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateActionTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateActionTargetRequestProtocolMarshaller(protocolFactory).marshall((UpdateActionTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateActionTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateActionTarget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateActionTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateActionTargetResult updateActionTargetResult = (UpdateActionTargetResult)response.getAwsResponse();
            return updateActionTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFindingsResult updateFindings(UpdateFindingsRequest request) {
        request = (UpdateFindingsRequest)this.beforeClientExecution(request);
        return this.executeUpdateFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFindingsResult executeUpdateFindings(UpdateFindingsRequest updateFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFindingsRequestProtocolMarshaller(protocolFactory).marshall((UpdateFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFindingsResult updateFindingsResult = (UpdateFindingsResult)response.getAwsResponse();
            return updateFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInsightResult updateInsight(UpdateInsightRequest request) {
        request = (UpdateInsightRequest)this.beforeClientExecution(request);
        return this.executeUpdateInsight(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInsightResult executeUpdateInsight(UpdateInsightRequest updateInsightRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInsightRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInsightRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInsightRequestProtocolMarshaller(protocolFactory).marshall((UpdateInsightRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateInsightRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SecurityHub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateInsight");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateInsightResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInsightResult updateInsightResult = (UpdateInsightResult)response.getAwsResponse();
            return updateInsightResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

