/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakermetrics;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sagemakermetrics.AmazonSageMakerMetricsAsync;
import com.amazonaws.services.sagemakermetrics.AmazonSageMakerMetricsAsyncClientBuilder;
import com.amazonaws.services.sagemakermetrics.AmazonSageMakerMetricsClient;
import com.amazonaws.services.sagemakermetrics.model.BatchPutMetricsRequest;
import com.amazonaws.services.sagemakermetrics.model.BatchPutMetricsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSageMakerMetricsAsyncClient
extends AmazonSageMakerMetricsClient
implements AmazonSageMakerMetricsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonSageMakerMetricsAsyncClientBuilder asyncBuilder() {
        return AmazonSageMakerMetricsAsyncClientBuilder.standard();
    }

    AmazonSageMakerMetricsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonSageMakerMetricsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchPutMetricsResult> batchPutMetricsAsync(BatchPutMetricsRequest request) {
        return this.batchPutMetricsAsync(request, null);
    }

    @Override
    public Future<BatchPutMetricsResult> batchPutMetricsAsync(BatchPutMetricsRequest request, final AsyncHandler<BatchPutMetricsRequest, BatchPutMetricsResult> asyncHandler) {
        final BatchPutMetricsRequest finalRequest = (BatchPutMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchPutMetricsResult>(){

            @Override
            public BatchPutMetricsResult call() throws Exception {
                BatchPutMetricsResult result = null;
                try {
                    result = AmazonSageMakerMetricsAsyncClient.this.executeBatchPutMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

