/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemakergeospatial.model.S3DataInput;

@SdkInternalApi
public class S3DataInputMarshaller {
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<String> METADATAPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetadataProvider").build();
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final S3DataInputMarshaller instance = new S3DataInputMarshaller();

    public static S3DataInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DataInput s3DataInput, ProtocolMarshaller protocolMarshaller) {
        if (s3DataInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3DataInput.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)s3DataInput.getMetadataProvider(), METADATAPROVIDER_BINDING);
            protocolMarshaller.marshall((Object)s3DataInput.getS3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

