/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakeredgemanager;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sagemakeredgemanager.AmazonSagemakerEdgeManagerAsync;
import com.amazonaws.services.sagemakeredgemanager.AmazonSagemakerEdgeManagerAsyncClientBuilder;
import com.amazonaws.services.sagemakeredgemanager.AmazonSagemakerEdgeManagerClient;
import com.amazonaws.services.sagemakeredgemanager.model.GetDeviceRegistrationRequest;
import com.amazonaws.services.sagemakeredgemanager.model.GetDeviceRegistrationResult;
import com.amazonaws.services.sagemakeredgemanager.model.SendHeartbeatRequest;
import com.amazonaws.services.sagemakeredgemanager.model.SendHeartbeatResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSagemakerEdgeManagerAsyncClient
extends AmazonSagemakerEdgeManagerClient
implements AmazonSagemakerEdgeManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonSagemakerEdgeManagerAsyncClientBuilder asyncBuilder() {
        return AmazonSagemakerEdgeManagerAsyncClientBuilder.standard();
    }

    AmazonSagemakerEdgeManagerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonSagemakerEdgeManagerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetDeviceRegistrationResult> getDeviceRegistrationAsync(GetDeviceRegistrationRequest request) {
        return this.getDeviceRegistrationAsync(request, null);
    }

    @Override
    public Future<GetDeviceRegistrationResult> getDeviceRegistrationAsync(GetDeviceRegistrationRequest request, final AsyncHandler<GetDeviceRegistrationRequest, GetDeviceRegistrationResult> asyncHandler) {
        final GetDeviceRegistrationRequest finalRequest = (GetDeviceRegistrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDeviceRegistrationResult>(){

            @Override
            public GetDeviceRegistrationResult call() throws Exception {
                GetDeviceRegistrationResult result = null;
                try {
                    result = AmazonSagemakerEdgeManagerAsyncClient.this.executeGetDeviceRegistration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendHeartbeatResult> sendHeartbeatAsync(SendHeartbeatRequest request) {
        return this.sendHeartbeatAsync(request, null);
    }

    @Override
    public Future<SendHeartbeatResult> sendHeartbeatAsync(SendHeartbeatRequest request, final AsyncHandler<SendHeartbeatRequest, SendHeartbeatResult> asyncHandler) {
        final SendHeartbeatRequest finalRequest = (SendHeartbeatRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendHeartbeatResult>(){

            @Override
            public SendHeartbeatResult call() throws Exception {
                SendHeartbeatResult result = null;
                try {
                    result = AmazonSagemakerEdgeManagerAsyncClient.this.executeSendHeartbeat(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

