/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AsyncInferenceConfig;
import com.amazonaws.services.sagemaker.model.DataCaptureConfig;
import com.amazonaws.services.sagemaker.model.ExplainerConfig;
import com.amazonaws.services.sagemaker.model.ProductionVariant;
import com.amazonaws.services.sagemaker.model.Tag;
import com.amazonaws.services.sagemaker.model.VpcConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateEndpointConfigRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String endpointConfigName;
    private List<ProductionVariant> productionVariants;
    private DataCaptureConfig dataCaptureConfig;
    private List<Tag> tags;
    private String kmsKeyId;
    private AsyncInferenceConfig asyncInferenceConfig;
    private ExplainerConfig explainerConfig;
    private List<ProductionVariant> shadowProductionVariants;
    private String executionRoleArn;
    private VpcConfig vpcConfig;
    private Boolean enableNetworkIsolation;

    public void setEndpointConfigName(String endpointConfigName) {
        this.endpointConfigName = endpointConfigName;
    }

    public String getEndpointConfigName() {
        return this.endpointConfigName;
    }

    public CreateEndpointConfigRequest withEndpointConfigName(String endpointConfigName) {
        this.setEndpointConfigName(endpointConfigName);
        return this;
    }

    public List<ProductionVariant> getProductionVariants() {
        return this.productionVariants;
    }

    public void setProductionVariants(Collection<ProductionVariant> productionVariants) {
        if (productionVariants == null) {
            this.productionVariants = null;
            return;
        }
        this.productionVariants = new ArrayList<ProductionVariant>(productionVariants);
    }

    public CreateEndpointConfigRequest withProductionVariants(ProductionVariant ... productionVariants) {
        if (this.productionVariants == null) {
            this.setProductionVariants(new ArrayList<ProductionVariant>(productionVariants.length));
        }
        for (ProductionVariant ele : productionVariants) {
            this.productionVariants.add(ele);
        }
        return this;
    }

    public CreateEndpointConfigRequest withProductionVariants(Collection<ProductionVariant> productionVariants) {
        this.setProductionVariants(productionVariants);
        return this;
    }

    public void setDataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
        this.dataCaptureConfig = dataCaptureConfig;
    }

    public DataCaptureConfig getDataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public CreateEndpointConfigRequest withDataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
        this.setDataCaptureConfig(dataCaptureConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateEndpointConfigRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateEndpointConfigRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateEndpointConfigRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setAsyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
        this.asyncInferenceConfig = asyncInferenceConfig;
    }

    public AsyncInferenceConfig getAsyncInferenceConfig() {
        return this.asyncInferenceConfig;
    }

    public CreateEndpointConfigRequest withAsyncInferenceConfig(AsyncInferenceConfig asyncInferenceConfig) {
        this.setAsyncInferenceConfig(asyncInferenceConfig);
        return this;
    }

    public void setExplainerConfig(ExplainerConfig explainerConfig) {
        this.explainerConfig = explainerConfig;
    }

    public ExplainerConfig getExplainerConfig() {
        return this.explainerConfig;
    }

    public CreateEndpointConfigRequest withExplainerConfig(ExplainerConfig explainerConfig) {
        this.setExplainerConfig(explainerConfig);
        return this;
    }

    public List<ProductionVariant> getShadowProductionVariants() {
        return this.shadowProductionVariants;
    }

    public void setShadowProductionVariants(Collection<ProductionVariant> shadowProductionVariants) {
        if (shadowProductionVariants == null) {
            this.shadowProductionVariants = null;
            return;
        }
        this.shadowProductionVariants = new ArrayList<ProductionVariant>(shadowProductionVariants);
    }

    public CreateEndpointConfigRequest withShadowProductionVariants(ProductionVariant ... shadowProductionVariants) {
        if (this.shadowProductionVariants == null) {
            this.setShadowProductionVariants(new ArrayList<ProductionVariant>(shadowProductionVariants.length));
        }
        for (ProductionVariant ele : shadowProductionVariants) {
            this.shadowProductionVariants.add(ele);
        }
        return this;
    }

    public CreateEndpointConfigRequest withShadowProductionVariants(Collection<ProductionVariant> shadowProductionVariants) {
        this.setShadowProductionVariants(shadowProductionVariants);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public CreateEndpointConfigRequest withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public CreateEndpointConfigRequest withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.enableNetworkIsolation = enableNetworkIsolation;
    }

    public Boolean getEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public CreateEndpointConfigRequest withEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.setEnableNetworkIsolation(enableNetworkIsolation);
        return this;
    }

    public Boolean isEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointConfigName() != null) {
            sb.append("EndpointConfigName: ").append(this.getEndpointConfigName()).append(",");
        }
        if (this.getProductionVariants() != null) {
            sb.append("ProductionVariants: ").append(this.getProductionVariants()).append(",");
        }
        if (this.getDataCaptureConfig() != null) {
            sb.append("DataCaptureConfig: ").append(this.getDataCaptureConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getAsyncInferenceConfig() != null) {
            sb.append("AsyncInferenceConfig: ").append(this.getAsyncInferenceConfig()).append(",");
        }
        if (this.getExplainerConfig() != null) {
            sb.append("ExplainerConfig: ").append(this.getExplainerConfig()).append(",");
        }
        if (this.getShadowProductionVariants() != null) {
            sb.append("ShadowProductionVariants: ").append(this.getShadowProductionVariants()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getEnableNetworkIsolation() != null) {
            sb.append("EnableNetworkIsolation: ").append(this.getEnableNetworkIsolation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointConfigRequest)) {
            return false;
        }
        CreateEndpointConfigRequest other = (CreateEndpointConfigRequest)obj;
        if (other.getEndpointConfigName() == null ^ this.getEndpointConfigName() == null) {
            return false;
        }
        if (other.getEndpointConfigName() != null && !other.getEndpointConfigName().equals(this.getEndpointConfigName())) {
            return false;
        }
        if (other.getProductionVariants() == null ^ this.getProductionVariants() == null) {
            return false;
        }
        if (other.getProductionVariants() != null && !other.getProductionVariants().equals(this.getProductionVariants())) {
            return false;
        }
        if (other.getDataCaptureConfig() == null ^ this.getDataCaptureConfig() == null) {
            return false;
        }
        if (other.getDataCaptureConfig() != null && !other.getDataCaptureConfig().equals(this.getDataCaptureConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getAsyncInferenceConfig() == null ^ this.getAsyncInferenceConfig() == null) {
            return false;
        }
        if (other.getAsyncInferenceConfig() != null && !other.getAsyncInferenceConfig().equals(this.getAsyncInferenceConfig())) {
            return false;
        }
        if (other.getExplainerConfig() == null ^ this.getExplainerConfig() == null) {
            return false;
        }
        if (other.getExplainerConfig() != null && !other.getExplainerConfig().equals(this.getExplainerConfig())) {
            return false;
        }
        if (other.getShadowProductionVariants() == null ^ this.getShadowProductionVariants() == null) {
            return false;
        }
        if (other.getShadowProductionVariants() != null && !other.getShadowProductionVariants().equals(this.getShadowProductionVariants())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getEnableNetworkIsolation() == null ^ this.getEnableNetworkIsolation() == null) {
            return false;
        }
        return other.getEnableNetworkIsolation() == null || other.getEnableNetworkIsolation().equals(this.getEnableNetworkIsolation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointConfigName() == null ? 0 : this.getEndpointConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getProductionVariants() == null ? 0 : this.getProductionVariants().hashCode());
        hashCode = 31 * hashCode + (this.getDataCaptureConfig() == null ? 0 : this.getDataCaptureConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getAsyncInferenceConfig() == null ? 0 : this.getAsyncInferenceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getExplainerConfig() == null ? 0 : this.getExplainerConfig().hashCode());
        hashCode = 31 * hashCode + (this.getShadowProductionVariants() == null ? 0 : this.getShadowProductionVariants().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEnableNetworkIsolation() == null ? 0 : this.getEnableNetworkIsolation().hashCode());
        return hashCode;
    }

    public CreateEndpointConfigRequest clone() {
        return (CreateEndpointConfigRequest)super.clone();
    }
}

