/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.ListMultiRegionAccessPointsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListMultiRegionAccessPointsRequestMarshaller
implements Marshaller<Request<ListMultiRegionAccessPointsRequest>, ListMultiRegionAccessPointsRequest> {
    public Request<ListMultiRegionAccessPointsRequest> marshall(ListMultiRegionAccessPointsRequest listMultiRegionAccessPointsRequest) {
        if (listMultiRegionAccessPointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listMultiRegionAccessPointsRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (listMultiRegionAccessPointsRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)listMultiRegionAccessPointsRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/mrap/instances";
        request.setResourcePath(uriResourcePath);
        if (listMultiRegionAccessPointsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listMultiRegionAccessPointsRequest.getNextToken()));
        }
        if (listMultiRegionAccessPointsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listMultiRegionAccessPointsRequest.getMaxResults()));
        }
        return request;
    }
}

