/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3control.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAccessGrantsLocationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private String locationScope;
    private String iAMRoleArn;
    private List<Tag> tags;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CreateAccessGrantsLocationRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setLocationScope(String locationScope) {
        this.locationScope = locationScope;
    }

    public String getLocationScope() {
        return this.locationScope;
    }

    public CreateAccessGrantsLocationRequest withLocationScope(String locationScope) {
        this.setLocationScope(locationScope);
        return this;
    }

    public void setIAMRoleArn(String iAMRoleArn) {
        this.iAMRoleArn = iAMRoleArn;
    }

    public String getIAMRoleArn() {
        return this.iAMRoleArn;
    }

    public CreateAccessGrantsLocationRequest withIAMRoleArn(String iAMRoleArn) {
        this.setIAMRoleArn(iAMRoleArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAccessGrantsLocationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAccessGrantsLocationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getLocationScope() != null) {
            sb.append("LocationScope: ").append(this.getLocationScope()).append(",");
        }
        if (this.getIAMRoleArn() != null) {
            sb.append("IAMRoleArn: ").append(this.getIAMRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantsLocationRequest)) {
            return false;
        }
        CreateAccessGrantsLocationRequest other = (CreateAccessGrantsLocationRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getLocationScope() == null ^ this.getLocationScope() == null) {
            return false;
        }
        if (other.getLocationScope() != null && !other.getLocationScope().equals(this.getLocationScope())) {
            return false;
        }
        if (other.getIAMRoleArn() == null ^ this.getIAMRoleArn() == null) {
            return false;
        }
        if (other.getIAMRoleArn() != null && !other.getIAMRoleArn().equals(this.getIAMRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getLocationScope() == null ? 0 : this.getLocationScope().hashCode());
        hashCode = 31 * hashCode + (this.getIAMRoleArn() == null ? 0 : this.getIAMRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAccessGrantsLocationRequest clone() {
        return (CreateAccessGrantsLocationRequest)super.clone();
    }
}

