/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.ListAccessGrantsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListAccessGrantsRequestMarshaller
implements Marshaller<Request<ListAccessGrantsRequest>, ListAccessGrantsRequest> {
    public Request<ListAccessGrantsRequest> marshall(ListAccessGrantsRequest listAccessGrantsRequest) {
        if (listAccessGrantsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAccessGrantsRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (listAccessGrantsRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)listAccessGrantsRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance/grants";
        request.setResourcePath(uriResourcePath);
        if (listAccessGrantsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listAccessGrantsRequest.getNextToken()));
        }
        if (listAccessGrantsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listAccessGrantsRequest.getMaxResults()));
        }
        if (listAccessGrantsRequest.getGranteeType() != null) {
            request.addParameter("granteetype", StringUtils.fromString((String)listAccessGrantsRequest.getGranteeType()));
        }
        if (listAccessGrantsRequest.getGranteeIdentifier() != null) {
            request.addParameter("granteeidentifier", StringUtils.fromString((String)listAccessGrantsRequest.getGranteeIdentifier()));
        }
        if (listAccessGrantsRequest.getPermission() != null) {
            request.addParameter("permission", StringUtils.fromString((String)listAccessGrantsRequest.getPermission()));
        }
        if (listAccessGrantsRequest.getGrantScope() != null) {
            request.addParameter("grantscope", StringUtils.fromString((String)listAccessGrantsRequest.getGrantScope()));
        }
        if (listAccessGrantsRequest.getApplicationArn() != null) {
            request.addParameter("application_arn", StringUtils.fromString((String)listAccessGrantsRequest.getApplicationArn()));
        }
        return request;
    }
}

