/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.MultiRegionAccessPointRoute;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MultiRegionAccessPointRouteStaxUnmarshaller
implements Unmarshaller<MultiRegionAccessPointRoute, StaxUnmarshallerContext> {
    private static MultiRegionAccessPointRouteStaxUnmarshaller instance;

    public MultiRegionAccessPointRoute unmarshall(StaxUnmarshallerContext context) throws Exception {
        MultiRegionAccessPointRoute multiRegionAccessPointRoute = new MultiRegionAccessPointRoute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return multiRegionAccessPointRoute;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Bucket", targetDepth)) {
                    multiRegionAccessPointRoute.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Region", targetDepth)) {
                    multiRegionAccessPointRoute.setRegion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TrafficDialPercentage", targetDepth)) continue;
                multiRegionAccessPointRoute.setTrafficDialPercentage(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return multiRegionAccessPointRoute;
    }

    public static MultiRegionAccessPointRouteStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MultiRegionAccessPointRouteStaxUnmarshaller();
        }
        return instance;
    }
}

