/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.KeyNameConstraint;
import com.amazonaws.services.s3control.model.ReplicationStatus;
import com.amazonaws.services.s3control.model.S3StorageClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class JobManifestGeneratorFilter
implements Serializable,
Cloneable {
    private Boolean eligibleForReplication;
    private Date createdAfter;
    private Date createdBefore;
    private List<String> objectReplicationStatuses;
    private KeyNameConstraint keyNameConstraint;
    private Long objectSizeGreaterThanBytes;
    private Long objectSizeLessThanBytes;
    private List<String> matchAnyStorageClass;

    public void setEligibleForReplication(Boolean eligibleForReplication) {
        this.eligibleForReplication = eligibleForReplication;
    }

    public Boolean getEligibleForReplication() {
        return this.eligibleForReplication;
    }

    public JobManifestGeneratorFilter withEligibleForReplication(Boolean eligibleForReplication) {
        this.setEligibleForReplication(eligibleForReplication);
        return this;
    }

    public Boolean isEligibleForReplication() {
        return this.eligibleForReplication;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public JobManifestGeneratorFilter withCreatedAfter(Date createdAfter) {
        this.setCreatedAfter(createdAfter);
        return this;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public JobManifestGeneratorFilter withCreatedBefore(Date createdBefore) {
        this.setCreatedBefore(createdBefore);
        return this;
    }

    public List<String> getObjectReplicationStatuses() {
        return this.objectReplicationStatuses;
    }

    public void setObjectReplicationStatuses(Collection<String> objectReplicationStatuses) {
        if (objectReplicationStatuses == null) {
            this.objectReplicationStatuses = null;
            return;
        }
        this.objectReplicationStatuses = new ArrayList<String>(objectReplicationStatuses);
    }

    public JobManifestGeneratorFilter withObjectReplicationStatuses(String ... objectReplicationStatuses) {
        if (this.objectReplicationStatuses == null) {
            this.setObjectReplicationStatuses(new ArrayList<String>(objectReplicationStatuses.length));
        }
        for (String ele : objectReplicationStatuses) {
            this.objectReplicationStatuses.add(ele);
        }
        return this;
    }

    public JobManifestGeneratorFilter withObjectReplicationStatuses(Collection<String> objectReplicationStatuses) {
        this.setObjectReplicationStatuses(objectReplicationStatuses);
        return this;
    }

    public JobManifestGeneratorFilter withObjectReplicationStatuses(ReplicationStatus ... objectReplicationStatuses) {
        ArrayList<String> objectReplicationStatusesCopy = new ArrayList<String>(objectReplicationStatuses.length);
        for (ReplicationStatus value : objectReplicationStatuses) {
            objectReplicationStatusesCopy.add(value.toString());
        }
        if (this.getObjectReplicationStatuses() == null) {
            this.setObjectReplicationStatuses(objectReplicationStatusesCopy);
        } else {
            this.getObjectReplicationStatuses().addAll(objectReplicationStatusesCopy);
        }
        return this;
    }

    public void setKeyNameConstraint(KeyNameConstraint keyNameConstraint) {
        this.keyNameConstraint = keyNameConstraint;
    }

    public KeyNameConstraint getKeyNameConstraint() {
        return this.keyNameConstraint;
    }

    public JobManifestGeneratorFilter withKeyNameConstraint(KeyNameConstraint keyNameConstraint) {
        this.setKeyNameConstraint(keyNameConstraint);
        return this;
    }

    public void setObjectSizeGreaterThanBytes(Long objectSizeGreaterThanBytes) {
        this.objectSizeGreaterThanBytes = objectSizeGreaterThanBytes;
    }

    public Long getObjectSizeGreaterThanBytes() {
        return this.objectSizeGreaterThanBytes;
    }

    public JobManifestGeneratorFilter withObjectSizeGreaterThanBytes(Long objectSizeGreaterThanBytes) {
        this.setObjectSizeGreaterThanBytes(objectSizeGreaterThanBytes);
        return this;
    }

    public void setObjectSizeLessThanBytes(Long objectSizeLessThanBytes) {
        this.objectSizeLessThanBytes = objectSizeLessThanBytes;
    }

    public Long getObjectSizeLessThanBytes() {
        return this.objectSizeLessThanBytes;
    }

    public JobManifestGeneratorFilter withObjectSizeLessThanBytes(Long objectSizeLessThanBytes) {
        this.setObjectSizeLessThanBytes(objectSizeLessThanBytes);
        return this;
    }

    public List<String> getMatchAnyStorageClass() {
        return this.matchAnyStorageClass;
    }

    public void setMatchAnyStorageClass(Collection<String> matchAnyStorageClass) {
        if (matchAnyStorageClass == null) {
            this.matchAnyStorageClass = null;
            return;
        }
        this.matchAnyStorageClass = new ArrayList<String>(matchAnyStorageClass);
    }

    public JobManifestGeneratorFilter withMatchAnyStorageClass(String ... matchAnyStorageClass) {
        if (this.matchAnyStorageClass == null) {
            this.setMatchAnyStorageClass(new ArrayList<String>(matchAnyStorageClass.length));
        }
        for (String ele : matchAnyStorageClass) {
            this.matchAnyStorageClass.add(ele);
        }
        return this;
    }

    public JobManifestGeneratorFilter withMatchAnyStorageClass(Collection<String> matchAnyStorageClass) {
        this.setMatchAnyStorageClass(matchAnyStorageClass);
        return this;
    }

    public JobManifestGeneratorFilter withMatchAnyStorageClass(S3StorageClass ... matchAnyStorageClass) {
        ArrayList<String> matchAnyStorageClassCopy = new ArrayList<String>(matchAnyStorageClass.length);
        for (S3StorageClass value : matchAnyStorageClass) {
            matchAnyStorageClassCopy.add(value.toString());
        }
        if (this.getMatchAnyStorageClass() == null) {
            this.setMatchAnyStorageClass(matchAnyStorageClassCopy);
        } else {
            this.getMatchAnyStorageClass().addAll(matchAnyStorageClassCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEligibleForReplication() != null) {
            sb.append("EligibleForReplication: ").append(this.getEligibleForReplication()).append(",");
        }
        if (this.getCreatedAfter() != null) {
            sb.append("CreatedAfter: ").append(this.getCreatedAfter()).append(",");
        }
        if (this.getCreatedBefore() != null) {
            sb.append("CreatedBefore: ").append(this.getCreatedBefore()).append(",");
        }
        if (this.getObjectReplicationStatuses() != null) {
            sb.append("ObjectReplicationStatuses: ").append(this.getObjectReplicationStatuses()).append(",");
        }
        if (this.getKeyNameConstraint() != null) {
            sb.append("KeyNameConstraint: ").append(this.getKeyNameConstraint()).append(",");
        }
        if (this.getObjectSizeGreaterThanBytes() != null) {
            sb.append("ObjectSizeGreaterThanBytes: ").append(this.getObjectSizeGreaterThanBytes()).append(",");
        }
        if (this.getObjectSizeLessThanBytes() != null) {
            sb.append("ObjectSizeLessThanBytes: ").append(this.getObjectSizeLessThanBytes()).append(",");
        }
        if (this.getMatchAnyStorageClass() != null) {
            sb.append("MatchAnyStorageClass: ").append(this.getMatchAnyStorageClass());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifestGeneratorFilter)) {
            return false;
        }
        JobManifestGeneratorFilter other = (JobManifestGeneratorFilter)obj;
        if (other.getEligibleForReplication() == null ^ this.getEligibleForReplication() == null) {
            return false;
        }
        if (other.getEligibleForReplication() != null && !other.getEligibleForReplication().equals(this.getEligibleForReplication())) {
            return false;
        }
        if (other.getCreatedAfter() == null ^ this.getCreatedAfter() == null) {
            return false;
        }
        if (other.getCreatedAfter() != null && !other.getCreatedAfter().equals(this.getCreatedAfter())) {
            return false;
        }
        if (other.getCreatedBefore() == null ^ this.getCreatedBefore() == null) {
            return false;
        }
        if (other.getCreatedBefore() != null && !other.getCreatedBefore().equals(this.getCreatedBefore())) {
            return false;
        }
        if (other.getObjectReplicationStatuses() == null ^ this.getObjectReplicationStatuses() == null) {
            return false;
        }
        if (other.getObjectReplicationStatuses() != null && !other.getObjectReplicationStatuses().equals(this.getObjectReplicationStatuses())) {
            return false;
        }
        if (other.getKeyNameConstraint() == null ^ this.getKeyNameConstraint() == null) {
            return false;
        }
        if (other.getKeyNameConstraint() != null && !other.getKeyNameConstraint().equals(this.getKeyNameConstraint())) {
            return false;
        }
        if (other.getObjectSizeGreaterThanBytes() == null ^ this.getObjectSizeGreaterThanBytes() == null) {
            return false;
        }
        if (other.getObjectSizeGreaterThanBytes() != null && !other.getObjectSizeGreaterThanBytes().equals(this.getObjectSizeGreaterThanBytes())) {
            return false;
        }
        if (other.getObjectSizeLessThanBytes() == null ^ this.getObjectSizeLessThanBytes() == null) {
            return false;
        }
        if (other.getObjectSizeLessThanBytes() != null && !other.getObjectSizeLessThanBytes().equals(this.getObjectSizeLessThanBytes())) {
            return false;
        }
        if (other.getMatchAnyStorageClass() == null ^ this.getMatchAnyStorageClass() == null) {
            return false;
        }
        return other.getMatchAnyStorageClass() == null || other.getMatchAnyStorageClass().equals(this.getMatchAnyStorageClass());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEligibleForReplication() == null ? 0 : this.getEligibleForReplication().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAfter() == null ? 0 : this.getCreatedAfter().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBefore() == null ? 0 : this.getCreatedBefore().hashCode());
        hashCode = 31 * hashCode + (this.getObjectReplicationStatuses() == null ? 0 : this.getObjectReplicationStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getKeyNameConstraint() == null ? 0 : this.getKeyNameConstraint().hashCode());
        hashCode = 31 * hashCode + (this.getObjectSizeGreaterThanBytes() == null ? 0 : this.getObjectSizeGreaterThanBytes().hashCode());
        hashCode = 31 * hashCode + (this.getObjectSizeLessThanBytes() == null ? 0 : this.getObjectSizeLessThanBytes().hashCode());
        hashCode = 31 * hashCode + (this.getMatchAnyStorageClass() == null ? 0 : this.getMatchAnyStorageClass().hashCode());
        return hashCode;
    }

    public JobManifestGeneratorFilter clone() {
        try {
            return (JobManifestGeneratorFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

