/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.UntagResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class UntagResourceRequestMarshaller
implements Marshaller<Request<UntagResourceRequest>, UntagResourceRequest> {
    public Request<UntagResourceRequest> marshall(UntagResourceRequest untagResourceRequest) {
        if (untagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)untagResourceRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (untagResourceRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)untagResourceRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/tags/{resourceArn+}";
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "resourceArn", untagResourceRequest.getResourceArn());
        request.setResourcePath(uriResourcePath);
        if (untagResourceRequest.getTagKeys() != null && !untagResourceRequest.getTagKeys().isEmpty()) {
            for (String value : untagResourceRequest.getTagKeys()) {
                request.addParameter("tagKeys", StringUtils.fromString((String)value));
            }
        }
        return request;
    }
}

