/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.AccessControlTranslation;
import com.amazonaws.services.s3control.model.EncryptionConfiguration;
import com.amazonaws.services.s3control.model.Metrics;
import com.amazonaws.services.s3control.model.ReplicationStorageClass;
import com.amazonaws.services.s3control.model.ReplicationTime;
import java.io.Serializable;

public class Destination
implements Serializable,
Cloneable {
    private String account;
    private String bucket;
    private ReplicationTime replicationTime;
    private AccessControlTranslation accessControlTranslation;
    private EncryptionConfiguration encryptionConfiguration;
    private Metrics metrics;
    private String storageClass;

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }

    public Destination withAccount(String account) {
        this.setAccount(account);
        return this;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Destination withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setReplicationTime(ReplicationTime replicationTime) {
        this.replicationTime = replicationTime;
    }

    public ReplicationTime getReplicationTime() {
        return this.replicationTime;
    }

    public Destination withReplicationTime(ReplicationTime replicationTime) {
        this.setReplicationTime(replicationTime);
        return this;
    }

    public void setAccessControlTranslation(AccessControlTranslation accessControlTranslation) {
        this.accessControlTranslation = accessControlTranslation;
    }

    public AccessControlTranslation getAccessControlTranslation() {
        return this.accessControlTranslation;
    }

    public Destination withAccessControlTranslation(AccessControlTranslation accessControlTranslation) {
        this.setAccessControlTranslation(accessControlTranslation);
        return this;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Destination withEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Destination withMetrics(Metrics metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public Destination withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public Destination withStorageClass(ReplicationStorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccount() != null) {
            sb.append("Account: ").append(this.getAccount()).append(",");
        }
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getReplicationTime() != null) {
            sb.append("ReplicationTime: ").append(this.getReplicationTime()).append(",");
        }
        if (this.getAccessControlTranslation() != null) {
            sb.append("AccessControlTranslation: ").append(this.getAccessControlTranslation()).append(",");
        }
        if (this.getEncryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.getEncryptionConfiguration()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        if (other.getAccount() == null ^ this.getAccount() == null) {
            return false;
        }
        if (other.getAccount() != null && !other.getAccount().equals(this.getAccount())) {
            return false;
        }
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getReplicationTime() == null ^ this.getReplicationTime() == null) {
            return false;
        }
        if (other.getReplicationTime() != null && !other.getReplicationTime().equals(this.getReplicationTime())) {
            return false;
        }
        if (other.getAccessControlTranslation() == null ^ this.getAccessControlTranslation() == null) {
            return false;
        }
        if (other.getAccessControlTranslation() != null && !other.getAccessControlTranslation().equals(this.getAccessControlTranslation())) {
            return false;
        }
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null) {
            return false;
        }
        if (other.getEncryptionConfiguration() != null && !other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        return other.getStorageClass() == null || other.getStorageClass().equals(this.getStorageClass());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccount() == null ? 0 : this.getAccount().hashCode());
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationTime() == null ? 0 : this.getReplicationTime().hashCode());
        hashCode = 31 * hashCode + (this.getAccessControlTranslation() == null ? 0 : this.getAccessControlTranslation().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfiguration() == null ? 0 : this.getEncryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        return hashCode;
    }

    public Destination clone() {
        try {
            return (Destination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

