/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.Region;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RegionStaxUnmarshaller
implements Unmarshaller<Region, StaxUnmarshallerContext> {
    private static RegionStaxUnmarshaller instance;

    public Region unmarshall(StaxUnmarshallerContext context) throws Exception {
        Region region = new Region();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return region;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Bucket", targetDepth)) continue;
                region.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return region;
    }

    public static RegionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RegionStaxUnmarshaller();
        }
        return instance;
    }
}

