/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.ActivityMetrics;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ActivityMetricsStaxUnmarshaller
implements Unmarshaller<ActivityMetrics, StaxUnmarshallerContext> {
    private static ActivityMetricsStaxUnmarshaller instance;

    public ActivityMetrics unmarshall(StaxUnmarshallerContext context) throws Exception {
        ActivityMetrics activityMetrics = new ActivityMetrics();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return activityMetrics;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("IsEnabled", targetDepth)) continue;
                activityMetrics.setIsEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return activityMetrics;
    }

    public static ActivityMetricsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ActivityMetricsStaxUnmarshaller();
        }
        return instance;
    }
}

