/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3control.model.StorageLensConfiguration;
import com.amazonaws.services.s3control.model.StorageLensTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutStorageLensConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String configId;
    private String accountId;
    private StorageLensConfiguration storageLensConfiguration;
    private List<StorageLensTag> tags;

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public String getConfigId() {
        return this.configId;
    }

    public PutStorageLensConfigurationRequest withConfigId(String configId) {
        this.setConfigId(configId);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public PutStorageLensConfigurationRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setStorageLensConfiguration(StorageLensConfiguration storageLensConfiguration) {
        this.storageLensConfiguration = storageLensConfiguration;
    }

    public StorageLensConfiguration getStorageLensConfiguration() {
        return this.storageLensConfiguration;
    }

    public PutStorageLensConfigurationRequest withStorageLensConfiguration(StorageLensConfiguration storageLensConfiguration) {
        this.setStorageLensConfiguration(storageLensConfiguration);
        return this;
    }

    public List<StorageLensTag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<StorageLensTag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<StorageLensTag>(tags);
    }

    public PutStorageLensConfigurationRequest withTags(StorageLensTag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<StorageLensTag>(tags.length));
        }
        for (StorageLensTag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public PutStorageLensConfigurationRequest withTags(Collection<StorageLensTag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigId() != null) {
            sb.append("ConfigId: ").append(this.getConfigId()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getStorageLensConfiguration() != null) {
            sb.append("StorageLensConfiguration: ").append(this.getStorageLensConfiguration()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStorageLensConfigurationRequest)) {
            return false;
        }
        PutStorageLensConfigurationRequest other = (PutStorageLensConfigurationRequest)obj;
        if (other.getConfigId() == null ^ this.getConfigId() == null) {
            return false;
        }
        if (other.getConfigId() != null && !other.getConfigId().equals(this.getConfigId())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getStorageLensConfiguration() == null ^ this.getStorageLensConfiguration() == null) {
            return false;
        }
        if (other.getStorageLensConfiguration() != null && !other.getStorageLensConfiguration().equals(this.getStorageLensConfiguration())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigId() == null ? 0 : this.getConfigId().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getStorageLensConfiguration() == null ? 0 : this.getStorageLensConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PutStorageLensConfigurationRequest clone() {
        return (PutStorageLensConfigurationRequest)super.clone();
    }
}

