/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.PrefixLevel;
import com.amazonaws.services.s3control.model.transform.PrefixLevelStorageMetricsStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PrefixLevelStaxUnmarshaller
implements Unmarshaller<PrefixLevel, StaxUnmarshallerContext> {
    private static PrefixLevelStaxUnmarshaller instance;

    public PrefixLevel unmarshall(StaxUnmarshallerContext context) throws Exception {
        PrefixLevel prefixLevel = new PrefixLevel();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return prefixLevel;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("StorageMetrics", targetDepth)) continue;
                prefixLevel.setStorageMetrics(PrefixLevelStorageMetricsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return prefixLevel;
    }

    public static PrefixLevelStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PrefixLevelStaxUnmarshaller();
        }
        return instance;
    }
}

